@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.vpclattice.kotlin

import com.pulumi.aws.vpclattice.AccessLogSubscriptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS VPC Lattice Service Network or Service Access log subscription.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.vpclattice.AccessLogSubscription;
 * import com.pulumi.aws.vpclattice.AccessLogSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AccessLogSubscription("example", AccessLogSubscriptionArgs.builder()
 *             .resourceIdentifier(aws_vpclattice_service_network.example().id())
 *             .destinationArn(aws_s3.bucket().arn())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import VPC Lattice Access Log Subscription using the access log subscription ID. For example:
 * ```sh
 *  $ pulumi import aws:vpclattice/accessLogSubscription:AccessLogSubscription example rft-8012925589
 * ```
 * @property destinationArn Amazon Resource Name (ARN) of the log destination.
 * @property resourceIdentifier The ID or Amazon Resource Identifier (ARN) of the service network or service. You must use the ARN if the resources specified in the operation are in different accounts.
 * @property tags
 */
public data class AccessLogSubscriptionArgs(
    public val destinationArn: Output<String>? = null,
    public val resourceIdentifier: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.vpclattice.AccessLogSubscriptionArgs> {
    override fun toJava(): com.pulumi.aws.vpclattice.AccessLogSubscriptionArgs =
        com.pulumi.aws.vpclattice.AccessLogSubscriptionArgs.builder()
            .destinationArn(destinationArn?.applyValue({ args0 -> args0 }))
            .resourceIdentifier(resourceIdentifier?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [AccessLogSubscriptionArgs].
 */
@PulumiTagMarker
public class AccessLogSubscriptionArgsBuilder internal constructor() {
    private var destinationArn: Output<String>? = null

    private var resourceIdentifier: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Amazon Resource Name (ARN) of the log destination.
     */
    @JvmName("aihtwflfxwrjyoxx")
    public suspend fun destinationArn(`value`: Output<String>) {
        this.destinationArn = value
    }

    /**
     * @param value The ID or Amazon Resource Identifier (ARN) of the service network or service. You must use the ARN if the resources specified in the operation are in different accounts.
     */
    @JvmName("jmrditkfstyhbjqo")
    public suspend fun resourceIdentifier(`value`: Output<String>) {
        this.resourceIdentifier = value
    }

    /**
     * @param value
     */
    @JvmName("wqtjyltnmvohbiri")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of the log destination.
     */
    @JvmName("wjxdktatqvsoodlk")
    public suspend fun destinationArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationArn = mapped
    }

    /**
     * @param value The ID or Amazon Resource Identifier (ARN) of the service network or service. You must use the ARN if the resources specified in the operation are in different accounts.
     */
    @JvmName("eovheyjgiikymrap")
    public suspend fun resourceIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceIdentifier = mapped
    }

    /**
     * @param value
     */
    @JvmName("oljbhkkokbdmmhfj")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values
     */
    @JvmName("mylmrrgbsjfwrxex")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): AccessLogSubscriptionArgs = AccessLogSubscriptionArgs(
        destinationArn = destinationArn,
        resourceIdentifier = resourceIdentifier,
        tags = tags,
    )
}
