@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.vpclattice.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [AuthPolicy].
 */
@PulumiTagMarker
public class AuthPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AuthPolicyArgs = AuthPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AuthPolicyArgsBuilder.() -> Unit) {
        val builder = AuthPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): AuthPolicy {
        val builtJavaResource = com.pulumi.aws.vpclattice.AuthPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AuthPolicy(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS VPC Lattice Auth Policy.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.vpclattice.Service;
 * import com.pulumi.aws.vpclattice.ServiceArgs;
 * import com.pulumi.aws.vpclattice.AuthPolicy;
 * import com.pulumi.aws.vpclattice.AuthPolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleService = new Service("exampleService", ServiceArgs.builder()
 *             .authType("AWS_IAM")
 *             .customDomainName("example.com")
 *             .build());
 *         var exampleAuthPolicy = new AuthPolicy("exampleAuthPolicy", AuthPolicyArgs.builder()
 *             .resourceIdentifier(exampleService.arn())
 *             .policy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Action", "*"),
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Principal", "*"),
 *                         jsonProperty("Resource", "*"),
 *                         jsonProperty("Condition", jsonObject(
 *                             jsonProperty("StringNotEqualsIgnoreCase", jsonObject(
 *                                 jsonProperty("aws:PrincipalType", "anonymous")
 *                             ))
 *                         ))
 *                     )))
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import VPC Lattice Auth Policy using the `example_id_arg`. For example:
 * ```sh
 *  $ pulumi import aws:vpclattice/authPolicy:AuthPolicy example rft-8012925589
 * ```
 *
 */
public class AuthPolicy internal constructor(
    override val javaResource: com.pulumi.aws.vpclattice.AuthPolicy,
) : KotlinCustomResource(javaResource, AuthPolicyMapper) {
    /**
     * The auth policy. The policy string in JSON must not contain newlines or blank lines.
     */
    public val policy: Output<String>
        get() = javaResource.policy().applyValue({ args0 -> args0 })

    /**
     * The ID or Amazon Resource Name (ARN) of the service network or service for which the policy is created.
     */
    public val resourceIdentifier: Output<String>
        get() = javaResource.resourceIdentifier().applyValue({ args0 -> args0 })

    /**
     * The state of the auth policy. The auth policy is only active when the auth type is set to AWS_IAM. If you provide a policy, then authentication and authorization decisions are made based on this policy and the client's IAM policy. If the Auth type is NONE, then, any auth policy you provide will remain inactive.
     */
    public val state: Output<String>?
        get() = javaResource.state().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object AuthPolicyMapper : ResourceMapper<AuthPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.vpclattice.AuthPolicy::class == javaResource::class

    override fun map(javaResource: Resource): AuthPolicy = AuthPolicy(
        javaResource as
            com.pulumi.aws.vpclattice.AuthPolicy,
    )
}

/**
 * @see [AuthPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AuthPolicy].
 */
public suspend fun authPolicy(name: String, block: suspend AuthPolicyResourceBuilder.() -> Unit):
    AuthPolicy {
    val builder = AuthPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AuthPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun authPolicy(name: String): AuthPolicy {
    val builder = AuthPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
