@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.vpclattice.kotlin

import com.pulumi.aws.vpclattice.AuthPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS VPC Lattice Auth Policy.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.vpclattice.Service;
 * import com.pulumi.aws.vpclattice.ServiceArgs;
 * import com.pulumi.aws.vpclattice.AuthPolicy;
 * import com.pulumi.aws.vpclattice.AuthPolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleService = new Service("exampleService", ServiceArgs.builder()
 *             .authType("AWS_IAM")
 *             .customDomainName("example.com")
 *             .build());
 *         var exampleAuthPolicy = new AuthPolicy("exampleAuthPolicy", AuthPolicyArgs.builder()
 *             .resourceIdentifier(exampleService.arn())
 *             .policy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Action", "*"),
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Principal", "*"),
 *                         jsonProperty("Resource", "*"),
 *                         jsonProperty("Condition", jsonObject(
 *                             jsonProperty("StringNotEqualsIgnoreCase", jsonObject(
 *                                 jsonProperty("aws:PrincipalType", "anonymous")
 *                             ))
 *                         ))
 *                     )))
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import VPC Lattice Auth Policy using the `example_id_arg`. For example:
 * ```sh
 *  $ pulumi import aws:vpclattice/authPolicy:AuthPolicy example rft-8012925589
 * ```
 * @property policy The auth policy. The policy string in JSON must not contain newlines or blank lines.
 * @property resourceIdentifier The ID or Amazon Resource Name (ARN) of the service network or service for which the policy is created.
 * @property state The state of the auth policy. The auth policy is only active when the auth type is set to AWS_IAM. If you provide a policy, then authentication and authorization decisions are made based on this policy and the client's IAM policy. If the Auth type is NONE, then, any auth policy you provide will remain inactive.
 */
public data class AuthPolicyArgs(
    public val policy: Output<String>? = null,
    public val resourceIdentifier: Output<String>? = null,
    public val state: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.vpclattice.AuthPolicyArgs> {
    override fun toJava(): com.pulumi.aws.vpclattice.AuthPolicyArgs =
        com.pulumi.aws.vpclattice.AuthPolicyArgs.builder()
            .policy(policy?.applyValue({ args0 -> args0 }))
            .resourceIdentifier(resourceIdentifier?.applyValue({ args0 -> args0 }))
            .state(state?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AuthPolicyArgs].
 */
@PulumiTagMarker
public class AuthPolicyArgsBuilder internal constructor() {
    private var policy: Output<String>? = null

    private var resourceIdentifier: Output<String>? = null

    private var state: Output<String>? = null

    /**
     * @param value The auth policy. The policy string in JSON must not contain newlines or blank lines.
     */
    @JvmName("sfervxkksdxitlqh")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value The ID or Amazon Resource Name (ARN) of the service network or service for which the policy is created.
     */
    @JvmName("opqkdkisxtpxhlaq")
    public suspend fun resourceIdentifier(`value`: Output<String>) {
        this.resourceIdentifier = value
    }

    /**
     * @param value The state of the auth policy. The auth policy is only active when the auth type is set to AWS_IAM. If you provide a policy, then authentication and authorization decisions are made based on this policy and the client's IAM policy. If the Auth type is NONE, then, any auth policy you provide will remain inactive.
     */
    @JvmName("ksplnclgkdflnffh")
    public suspend fun state(`value`: Output<String>) {
        this.state = value
    }

    /**
     * @param value The auth policy. The policy string in JSON must not contain newlines or blank lines.
     */
    @JvmName("tanmpodlqlqlnote")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param value The ID or Amazon Resource Name (ARN) of the service network or service for which the policy is created.
     */
    @JvmName("cuppnaftovfvyxbo")
    public suspend fun resourceIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceIdentifier = mapped
    }

    /**
     * @param value The state of the auth policy. The auth policy is only active when the auth type is set to AWS_IAM. If you provide a policy, then authentication and authorization decisions are made based on this policy and the client's IAM policy. If the Auth type is NONE, then, any auth policy you provide will remain inactive.
     */
    @JvmName("sfjjpdltxmophtmj")
    public suspend fun state(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    internal fun build(): AuthPolicyArgs = AuthPolicyArgs(
        policy = policy,
        resourceIdentifier = resourceIdentifier,
        state = state,
    )
}
