@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.vpclattice.kotlin

import com.pulumi.aws.vpclattice.kotlin.outputs.ListenerDefaultAction
import com.pulumi.aws.vpclattice.kotlin.outputs.ListenerDefaultAction.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Listener].
 */
@PulumiTagMarker
public class ListenerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ListenerArgs = ListenerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ListenerArgsBuilder.() -> Unit) {
        val builder = ListenerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Listener {
        val builtJavaResource = com.pulumi.aws.vpclattice.Listener(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Listener(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS VPC Lattice Listener.
 * ## Example Usage
 * ### Forward action
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.vpclattice.Service;
 * import com.pulumi.aws.vpclattice.TargetGroup;
 * import com.pulumi.aws.vpclattice.TargetGroupArgs;
 * import com.pulumi.aws.vpclattice.inputs.TargetGroupConfigArgs;
 * import com.pulumi.aws.vpclattice.Listener;
 * import com.pulumi.aws.vpclattice.ListenerArgs;
 * import com.pulumi.aws.vpclattice.inputs.ListenerDefaultActionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Service("test");
 *         var exampleTargetGroup = new TargetGroup("exampleTargetGroup", TargetGroupArgs.builder()
 *             .type("INSTANCE")
 *             .config(TargetGroupConfigArgs.builder()
 *                 .port(80)
 *                 .protocol("HTTP")
 *                 .vpcIdentifier(aws_vpc.test().id())
 *                 .build())
 *             .build());
 *         var exampleListener = new Listener("exampleListener", ListenerArgs.builder()
 *             .protocol("HTTP")
 *             .serviceIdentifier(aws_vpclattice_service.example().id())
 *             .defaultAction(ListenerDefaultActionArgs.builder()
 *                 .forwards(ListenerDefaultActionForwardArgs.builder()
 *                     .targetGroups(ListenerDefaultActionForwardTargetGroupArgs.builder()
 *                         .targetGroupIdentifier(exampleTargetGroup.id())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Forward action with weighted target groups
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.vpclattice.Service;
 * import com.pulumi.aws.vpclattice.TargetGroup;
 * import com.pulumi.aws.vpclattice.TargetGroupArgs;
 * import com.pulumi.aws.vpclattice.inputs.TargetGroupConfigArgs;
 * import com.pulumi.aws.vpclattice.Listener;
 * import com.pulumi.aws.vpclattice.ListenerArgs;
 * import com.pulumi.aws.vpclattice.inputs.ListenerDefaultActionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Service("test");
 *         var example1 = new TargetGroup("example1", TargetGroupArgs.builder()
 *             .type("INSTANCE")
 *             .config(TargetGroupConfigArgs.builder()
 *                 .port(80)
 *                 .protocol("HTTP")
 *                 .vpcIdentifier(aws_vpc.test().id())
 *                 .build())
 *             .build());
 *         var example2 = new TargetGroup("example2", TargetGroupArgs.builder()
 *             .type("INSTANCE")
 *             .config(TargetGroupConfigArgs.builder()
 *                 .port(8080)
 *                 .protocol("HTTP")
 *                 .vpcIdentifier(aws_vpc.test().id())
 *                 .build())
 *             .build());
 *         var example = new Listener("example", ListenerArgs.builder()
 *             .protocol("HTTP")
 *             .serviceIdentifier(aws_vpclattice_service.example().id())
 *             .defaultAction(ListenerDefaultActionArgs.builder()
 *                 .forwards(ListenerDefaultActionForwardArgs.builder()
 *                     .targetGroups(
 *                         ListenerDefaultActionForwardTargetGroupArgs.builder()
 *                             .targetGroupIdentifier(example1.id())
 *                             .weight(80)
 *                             .build(),
 *                         ListenerDefaultActionForwardTargetGroupArgs.builder()
 *                             .targetGroupIdentifier(example2.id())
 *                             .weight(20)
 *                             .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import VPC Lattice Listener using the `listener_id` of the listener and the `id` of the VPC Lattice service combined with a `/` character. For example:
 * ```sh
 *  $ pulumi import aws:vpclattice/listener:Listener example svc-1a2b3c4d/listener-987654321
 * ```
 *
 */
public class Listener internal constructor(
    override val javaResource: com.pulumi.aws.vpclattice.Listener,
) : KotlinCustomResource(javaResource, ListenerMapper) {
    /**
     * ARN of the listener.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Date and time that the listener was created, specified in ISO-8601 format.
     */
    public val createdAt: Output<String>
        get() = javaResource.createdAt().applyValue({ args0 -> args0 })

    /**
     * Default action block for the default listener rule. Default action blocks are defined below.
     */
    public val defaultAction: Output<ListenerDefaultAction>
        get() = javaResource.defaultAction().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })

    public val lastUpdatedAt: Output<String>
        get() = javaResource.lastUpdatedAt().applyValue({ args0 -> args0 })

    /**
     * Standalone ID of the listener, e.g. `listener-0a1b2c3d4e5f6g`.
     */
    public val listenerId: Output<String>
        get() = javaResource.listenerId().applyValue({ args0 -> args0 })

    /**
     * Name of the listener. A listener name must be unique within a service. Valid characters are a-z, 0-9, and hyphens (-). You can't use a hyphen as the first or last character, or immediately after another hyphen.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Listener port. You can specify a value from 1 to 65535. If `port` is not specified and `protocol` is HTTP, the value will default to 80. If `port` is not specified and `protocol` is HTTPS, the value will default to 443.
     */
    public val port: Output<Int>
        get() = javaResource.port().applyValue({ args0 -> args0 })

    /**
     * Protocol for the listener. Supported values are `HTTP` or `HTTPS`
     */
    public val protocol: Output<String>
        get() = javaResource.protocol().applyValue({ args0 -> args0 })

    /**
     * Amazon Resource Name (ARN) of the VPC Lattice service. You must include either the `service_arn` or `service_identifier` arguments.
     */
    public val serviceArn: Output<String>
        get() = javaResource.serviceArn().applyValue({ args0 -> args0 })

    /**
     * ID of the VPC Lattice service. You must include either the `service_arn` or `service_identifier` arguments.
     * > **NOTE:** You must specify one of the following arguments: `service_arn` or `service_identifier`.
     */
    public val serviceIdentifier: Output<String>
        get() = javaResource.serviceIdentifier().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object ListenerMapper : ResourceMapper<Listener> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.vpclattice.Listener::class == javaResource::class

    override fun map(javaResource: Resource): Listener = Listener(
        javaResource as
            com.pulumi.aws.vpclattice.Listener,
    )
}

/**
 * @see [Listener].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Listener].
 */
public suspend fun listener(name: String, block: suspend ListenerResourceBuilder.() -> Unit):
    Listener {
    val builder = ListenerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Listener].
 * @param name The _unique_ name of the resulting resource.
 */
public fun listener(name: String): Listener {
    val builder = ListenerResourceBuilder()
    builder.name(name)
    return builder.build()
}
