@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.vpclattice.kotlin

import com.pulumi.aws.vpclattice.ListenerArgs.builder
import com.pulumi.aws.vpclattice.kotlin.inputs.ListenerDefaultActionArgs
import com.pulumi.aws.vpclattice.kotlin.inputs.ListenerDefaultActionArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS VPC Lattice Listener.
 * ## Example Usage
 * ### Forward action
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.vpclattice.Service;
 * import com.pulumi.aws.vpclattice.TargetGroup;
 * import com.pulumi.aws.vpclattice.TargetGroupArgs;
 * import com.pulumi.aws.vpclattice.inputs.TargetGroupConfigArgs;
 * import com.pulumi.aws.vpclattice.Listener;
 * import com.pulumi.aws.vpclattice.ListenerArgs;
 * import com.pulumi.aws.vpclattice.inputs.ListenerDefaultActionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Service("test");
 *         var exampleTargetGroup = new TargetGroup("exampleTargetGroup", TargetGroupArgs.builder()
 *             .type("INSTANCE")
 *             .config(TargetGroupConfigArgs.builder()
 *                 .port(80)
 *                 .protocol("HTTP")
 *                 .vpcIdentifier(aws_vpc.test().id())
 *                 .build())
 *             .build());
 *         var exampleListener = new Listener("exampleListener", ListenerArgs.builder()
 *             .protocol("HTTP")
 *             .serviceIdentifier(aws_vpclattice_service.example().id())
 *             .defaultAction(ListenerDefaultActionArgs.builder()
 *                 .forwards(ListenerDefaultActionForwardArgs.builder()
 *                     .targetGroups(ListenerDefaultActionForwardTargetGroupArgs.builder()
 *                         .targetGroupIdentifier(exampleTargetGroup.id())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Forward action with weighted target groups
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.vpclattice.Service;
 * import com.pulumi.aws.vpclattice.TargetGroup;
 * import com.pulumi.aws.vpclattice.TargetGroupArgs;
 * import com.pulumi.aws.vpclattice.inputs.TargetGroupConfigArgs;
 * import com.pulumi.aws.vpclattice.Listener;
 * import com.pulumi.aws.vpclattice.ListenerArgs;
 * import com.pulumi.aws.vpclattice.inputs.ListenerDefaultActionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Service("test");
 *         var example1 = new TargetGroup("example1", TargetGroupArgs.builder()
 *             .type("INSTANCE")
 *             .config(TargetGroupConfigArgs.builder()
 *                 .port(80)
 *                 .protocol("HTTP")
 *                 .vpcIdentifier(aws_vpc.test().id())
 *                 .build())
 *             .build());
 *         var example2 = new TargetGroup("example2", TargetGroupArgs.builder()
 *             .type("INSTANCE")
 *             .config(TargetGroupConfigArgs.builder()
 *                 .port(8080)
 *                 .protocol("HTTP")
 *                 .vpcIdentifier(aws_vpc.test().id())
 *                 .build())
 *             .build());
 *         var example = new Listener("example", ListenerArgs.builder()
 *             .protocol("HTTP")
 *             .serviceIdentifier(aws_vpclattice_service.example().id())
 *             .defaultAction(ListenerDefaultActionArgs.builder()
 *                 .forwards(ListenerDefaultActionForwardArgs.builder()
 *                     .targetGroups(
 *                         ListenerDefaultActionForwardTargetGroupArgs.builder()
 *                             .targetGroupIdentifier(example1.id())
 *                             .weight(80)
 *                             .build(),
 *                         ListenerDefaultActionForwardTargetGroupArgs.builder()
 *                             .targetGroupIdentifier(example2.id())
 *                             .weight(20)
 *                             .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import VPC Lattice Listener using the `listener_id` of the listener and the `id` of the VPC Lattice service combined with a `/` character. For example:
 * ```sh
 *  $ pulumi import aws:vpclattice/listener:Listener example svc-1a2b3c4d/listener-987654321
 * ```
 * @property defaultAction Default action block for the default listener rule. Default action blocks are defined below.
 * @property name Name of the listener. A listener name must be unique within a service. Valid characters are a-z, 0-9, and hyphens (-). You can't use a hyphen as the first or last character, or immediately after another hyphen.
 * @property port Listener port. You can specify a value from 1 to 65535. If `port` is not specified and `protocol` is HTTP, the value will default to 80. If `port` is not specified and `protocol` is HTTPS, the value will default to 443.
 * @property protocol Protocol for the listener. Supported values are `HTTP` or `HTTPS`
 * @property serviceArn Amazon Resource Name (ARN) of the VPC Lattice service. You must include either the `service_arn` or `service_identifier` arguments.
 * @property serviceIdentifier ID of the VPC Lattice service. You must include either the `service_arn` or `service_identifier` arguments.
 * > **NOTE:** You must specify one of the following arguments: `service_arn` or `service_identifier`.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class ListenerArgs(
    public val defaultAction: Output<ListenerDefaultActionArgs>? = null,
    public val name: Output<String>? = null,
    public val port: Output<Int>? = null,
    public val protocol: Output<String>? = null,
    public val serviceArn: Output<String>? = null,
    public val serviceIdentifier: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.vpclattice.ListenerArgs> {
    override fun toJava(): com.pulumi.aws.vpclattice.ListenerArgs =
        com.pulumi.aws.vpclattice.ListenerArgs.builder()
            .defaultAction(defaultAction?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .port(port?.applyValue({ args0 -> args0 }))
            .protocol(protocol?.applyValue({ args0 -> args0 }))
            .serviceArn(serviceArn?.applyValue({ args0 -> args0 }))
            .serviceIdentifier(serviceIdentifier?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ListenerArgs].
 */
@PulumiTagMarker
public class ListenerArgsBuilder internal constructor() {
    private var defaultAction: Output<ListenerDefaultActionArgs>? = null

    private var name: Output<String>? = null

    private var port: Output<Int>? = null

    private var protocol: Output<String>? = null

    private var serviceArn: Output<String>? = null

    private var serviceIdentifier: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Default action block for the default listener rule. Default action blocks are defined below.
     */
    @JvmName("wmlhijxqepavoeuh")
    public suspend fun defaultAction(`value`: Output<ListenerDefaultActionArgs>) {
        this.defaultAction = value
    }

    /**
     * @param value Name of the listener. A listener name must be unique within a service. Valid characters are a-z, 0-9, and hyphens (-). You can't use a hyphen as the first or last character, or immediately after another hyphen.
     */
    @JvmName("gudjojiahttmpstq")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Listener port. You can specify a value from 1 to 65535. If `port` is not specified and `protocol` is HTTP, the value will default to 80. If `port` is not specified and `protocol` is HTTPS, the value will default to 443.
     */
    @JvmName("bfxtsmwkivvyjpvc")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value Protocol for the listener. Supported values are `HTTP` or `HTTPS`
     */
    @JvmName("xkfaphiktflafxva")
    public suspend fun protocol(`value`: Output<String>) {
        this.protocol = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of the VPC Lattice service. You must include either the `service_arn` or `service_identifier` arguments.
     */
    @JvmName("elxwoiosymliipuv")
    public suspend fun serviceArn(`value`: Output<String>) {
        this.serviceArn = value
    }

    /**
     * @param value ID of the VPC Lattice service. You must include either the `service_arn` or `service_identifier` arguments.
     * > **NOTE:** You must specify one of the following arguments: `service_arn` or `service_identifier`.
     */
    @JvmName("tlautfcsatttisbw")
    public suspend fun serviceIdentifier(`value`: Output<String>) {
        this.serviceIdentifier = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("wmefjqnhrnddhcif")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Default action block for the default listener rule. Default action blocks are defined below.
     */
    @JvmName("xokwqajswgguebjx")
    public suspend fun defaultAction(`value`: ListenerDefaultActionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultAction = mapped
    }

    /**
     * @param argument Default action block for the default listener rule. Default action blocks are defined below.
     */
    @JvmName("tgotoigjgoihmxaa")
    public suspend fun defaultAction(argument: suspend ListenerDefaultActionArgsBuilder.() -> Unit) {
        val toBeMapped = ListenerDefaultActionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.defaultAction = mapped
    }

    /**
     * @param value Name of the listener. A listener name must be unique within a service. Valid characters are a-z, 0-9, and hyphens (-). You can't use a hyphen as the first or last character, or immediately after another hyphen.
     */
    @JvmName("jdwblpbmtfhnjofb")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Listener port. You can specify a value from 1 to 65535. If `port` is not specified and `protocol` is HTTP, the value will default to 80. If `port` is not specified and `protocol` is HTTPS, the value will default to 443.
     */
    @JvmName("ytlrbspqhggupaug")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value Protocol for the listener. Supported values are `HTTP` or `HTTPS`
     */
    @JvmName("tmqyvefuuinpyyhv")
    public suspend fun protocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value Amazon Resource Name (ARN) of the VPC Lattice service. You must include either the `service_arn` or `service_identifier` arguments.
     */
    @JvmName("hyxdkgkgyfvrrkme")
    public suspend fun serviceArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceArn = mapped
    }

    /**
     * @param value ID of the VPC Lattice service. You must include either the `service_arn` or `service_identifier` arguments.
     * > **NOTE:** You must specify one of the following arguments: `service_arn` or `service_identifier`.
     */
    @JvmName("obhajcbinwfpunkh")
    public suspend fun serviceIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceIdentifier = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vntbqprylejearlp")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ogoavgfuwgkxpmor")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ListenerArgs = ListenerArgs(
        defaultAction = defaultAction,
        name = name,
        port = port,
        protocol = protocol,
        serviceArn = serviceArn,
        serviceIdentifier = serviceIdentifier,
        tags = tags,
    )
}
