@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.vpclattice.kotlin

import com.pulumi.aws.vpclattice.kotlin.outputs.ListenerRuleAction
import com.pulumi.aws.vpclattice.kotlin.outputs.ListenerRuleMatch
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.vpclattice.kotlin.outputs.ListenerRuleAction.Companion.toKotlin as listenerRuleActionToKotlin
import com.pulumi.aws.vpclattice.kotlin.outputs.ListenerRuleMatch.Companion.toKotlin as listenerRuleMatchToKotlin

/**
 * Builder for [ListenerRule].
 */
@PulumiTagMarker
public class ListenerRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ListenerRuleArgs = ListenerRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ListenerRuleArgsBuilder.() -> Unit) {
        val builder = ListenerRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ListenerRule {
        val builtJavaResource = com.pulumi.aws.vpclattice.ListenerRule(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ListenerRule(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS VPC Lattice Listener Rule.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.vpclattice.ListenerRule;
 * import com.pulumi.aws.vpclattice.ListenerRuleArgs;
 * import com.pulumi.aws.vpclattice.inputs.ListenerRuleMatchArgs;
 * import com.pulumi.aws.vpclattice.inputs.ListenerRuleMatchHttpMatchArgs;
 * import com.pulumi.aws.vpclattice.inputs.ListenerRuleMatchHttpMatchPathMatchArgs;
 * import com.pulumi.aws.vpclattice.inputs.ListenerRuleMatchHttpMatchPathMatchMatchArgs;
 * import com.pulumi.aws.vpclattice.inputs.ListenerRuleActionArgs;
 * import com.pulumi.aws.vpclattice.inputs.ListenerRuleActionForwardArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new ListenerRule("test", ListenerRuleArgs.builder()
 *             .listenerIdentifier(aws_vpclattice_listener.example().listener_id())
 *             .serviceIdentifier(aws_vpclattice_service.example().id())
 *             .priority(20)
 *             .match(ListenerRuleMatchArgs.builder()
 *                 .httpMatch(ListenerRuleMatchHttpMatchArgs.builder()
 *                     .headerMatches(ListenerRuleMatchHttpMatchHeaderMatchArgs.builder()
 *                         .name("example-header")
 *                         .caseSensitive(false)
 *                         .match(ListenerRuleMatchHttpMatchHeaderMatchMatchArgs.builder()
 *                             .exact("example-contains")
 *                             .build())
 *                         .build())
 *                     .pathMatch(ListenerRuleMatchHttpMatchPathMatchArgs.builder()
 *                         .caseSensitive(true)
 *                         .match(ListenerRuleMatchHttpMatchPathMatchMatchArgs.builder()
 *                             .prefix("/example-path")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .action(ListenerRuleActionArgs.builder()
 *                 .forward(ListenerRuleActionForwardArgs.builder()
 *                     .targetGroups(
 *                         ListenerRuleActionForwardTargetGroupArgs.builder()
 *                             .targetGroupIdentifier(aws_vpclattice_target_group.example().id())
 *                             .weight(1)
 *                             .build(),
 *                         ListenerRuleActionForwardTargetGroupArgs.builder()
 *                             .targetGroupIdentifier(aws_vpclattice_target_group.example2().id())
 *                             .weight(2)
 *                             .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.vpclattice.ListenerRule;
 * import com.pulumi.aws.vpclattice.ListenerRuleArgs;
 * import com.pulumi.aws.vpclattice.inputs.ListenerRuleMatchArgs;
 * import com.pulumi.aws.vpclattice.inputs.ListenerRuleMatchHttpMatchArgs;
 * import com.pulumi.aws.vpclattice.inputs.ListenerRuleMatchHttpMatchPathMatchArgs;
 * import com.pulumi.aws.vpclattice.inputs.ListenerRuleMatchHttpMatchPathMatchMatchArgs;
 * import com.pulumi.aws.vpclattice.inputs.ListenerRuleActionArgs;
 * import com.pulumi.aws.vpclattice.inputs.ListenerRuleActionFixedResponseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new ListenerRule("test", ListenerRuleArgs.builder()
 *             .listenerIdentifier(aws_vpclattice_listener.example().listener_id())
 *             .serviceIdentifier(aws_vpclattice_service.example().id())
 *             .priority(10)
 *             .match(ListenerRuleMatchArgs.builder()
 *                 .httpMatch(ListenerRuleMatchHttpMatchArgs.builder()
 *                     .pathMatch(ListenerRuleMatchHttpMatchPathMatchArgs.builder()
 *                         .caseSensitive(false)
 *                         .match(ListenerRuleMatchHttpMatchPathMatchMatchArgs.builder()
 *                             .exact("/example-path")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .action(ListenerRuleActionArgs.builder()
 *                 .fixedResponse(ListenerRuleActionFixedResponseArgs.builder()
 *                     .statusCode(404)
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import VPC Lattice Listener Rule using the `example_id_arg`. For example:
 * ```sh
 *  $ pulumi import aws:vpclattice/listenerRule:ListenerRule example rft-8012925589
 * ```
 *
 */
public class ListenerRule internal constructor(
    override val javaResource: com.pulumi.aws.vpclattice.ListenerRule,
) : KotlinCustomResource(javaResource, ListenerRuleMapper) {
    /**
     * The action for the listener rule.
     */
    public val action: Output<ListenerRuleAction>
        get() = javaResource.action().applyValue({ args0 ->
            args0.let({ args0 ->
                listenerRuleActionToKotlin(args0)
            })
        })

    /**
     * The ARN for the listener rule.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The ID or Amazon Resource Name (ARN) of the listener.
     */
    public val listenerIdentifier: Output<String>
        get() = javaResource.listenerIdentifier().applyValue({ args0 -> args0 })

    /**
     * The rule match.
     */
    public val match: Output<ListenerRuleMatch>
        get() = javaResource.match().applyValue({ args0 ->
            args0.let({ args0 ->
                listenerRuleMatchToKotlin(args0)
            })
        })

    /**
     * The name of the rule. The name must be unique within the listener. The valid characters are a-z, 0-9, and hyphens (-). You can't use a hyphen as the first or last character, or immediately after another hyphen.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The priority assigned to the rule. Each rule for a specific listener must have a unique priority. The lower the priority number the higher the priority.
     * The following arguments are optional:
     */
    public val priority: Output<Int>
        get() = javaResource.priority().applyValue({ args0 -> args0 })

    /**
     * Unique identifier for the listener rule.
     */
    public val ruleId: Output<String>
        get() = javaResource.ruleId().applyValue({ args0 -> args0 })

    /**
     * The ID or Amazon Resource Identifier (ARN) of the service.
     */
    public val serviceIdentifier: Output<String>
        get() = javaResource.serviceIdentifier().applyValue({ args0 -> args0 })

    /**
     * Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object ListenerRuleMapper : ResourceMapper<ListenerRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.vpclattice.ListenerRule::class == javaResource::class

    override fun map(javaResource: Resource): ListenerRule = ListenerRule(
        javaResource as
            com.pulumi.aws.vpclattice.ListenerRule,
    )
}

/**
 * @see [ListenerRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ListenerRule].
 */
public suspend fun listenerRule(
    name: String,
    block: suspend ListenerRuleResourceBuilder.() -> Unit,
): ListenerRule {
    val builder = ListenerRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ListenerRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun listenerRule(name: String): ListenerRule {
    val builder = ListenerRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
