@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.vpclattice.kotlin

import com.pulumi.aws.vpclattice.ListenerRuleArgs.builder
import com.pulumi.aws.vpclattice.kotlin.inputs.ListenerRuleActionArgs
import com.pulumi.aws.vpclattice.kotlin.inputs.ListenerRuleActionArgsBuilder
import com.pulumi.aws.vpclattice.kotlin.inputs.ListenerRuleMatchArgs
import com.pulumi.aws.vpclattice.kotlin.inputs.ListenerRuleMatchArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS VPC Lattice Listener Rule.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.vpclattice.ListenerRule;
 * import com.pulumi.aws.vpclattice.ListenerRuleArgs;
 * import com.pulumi.aws.vpclattice.inputs.ListenerRuleMatchArgs;
 * import com.pulumi.aws.vpclattice.inputs.ListenerRuleMatchHttpMatchArgs;
 * import com.pulumi.aws.vpclattice.inputs.ListenerRuleMatchHttpMatchPathMatchArgs;
 * import com.pulumi.aws.vpclattice.inputs.ListenerRuleMatchHttpMatchPathMatchMatchArgs;
 * import com.pulumi.aws.vpclattice.inputs.ListenerRuleActionArgs;
 * import com.pulumi.aws.vpclattice.inputs.ListenerRuleActionForwardArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new ListenerRule("test", ListenerRuleArgs.builder()
 *             .listenerIdentifier(aws_vpclattice_listener.example().listener_id())
 *             .serviceIdentifier(aws_vpclattice_service.example().id())
 *             .priority(20)
 *             .match(ListenerRuleMatchArgs.builder()
 *                 .httpMatch(ListenerRuleMatchHttpMatchArgs.builder()
 *                     .headerMatches(ListenerRuleMatchHttpMatchHeaderMatchArgs.builder()
 *                         .name("example-header")
 *                         .caseSensitive(false)
 *                         .match(ListenerRuleMatchHttpMatchHeaderMatchMatchArgs.builder()
 *                             .exact("example-contains")
 *                             .build())
 *                         .build())
 *                     .pathMatch(ListenerRuleMatchHttpMatchPathMatchArgs.builder()
 *                         .caseSensitive(true)
 *                         .match(ListenerRuleMatchHttpMatchPathMatchMatchArgs.builder()
 *                             .prefix("/example-path")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .action(ListenerRuleActionArgs.builder()
 *                 .forward(ListenerRuleActionForwardArgs.builder()
 *                     .targetGroups(
 *                         ListenerRuleActionForwardTargetGroupArgs.builder()
 *                             .targetGroupIdentifier(aws_vpclattice_target_group.example().id())
 *                             .weight(1)
 *                             .build(),
 *                         ListenerRuleActionForwardTargetGroupArgs.builder()
 *                             .targetGroupIdentifier(aws_vpclattice_target_group.example2().id())
 *                             .weight(2)
 *                             .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.vpclattice.ListenerRule;
 * import com.pulumi.aws.vpclattice.ListenerRuleArgs;
 * import com.pulumi.aws.vpclattice.inputs.ListenerRuleMatchArgs;
 * import com.pulumi.aws.vpclattice.inputs.ListenerRuleMatchHttpMatchArgs;
 * import com.pulumi.aws.vpclattice.inputs.ListenerRuleMatchHttpMatchPathMatchArgs;
 * import com.pulumi.aws.vpclattice.inputs.ListenerRuleMatchHttpMatchPathMatchMatchArgs;
 * import com.pulumi.aws.vpclattice.inputs.ListenerRuleActionArgs;
 * import com.pulumi.aws.vpclattice.inputs.ListenerRuleActionFixedResponseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new ListenerRule("test", ListenerRuleArgs.builder()
 *             .listenerIdentifier(aws_vpclattice_listener.example().listener_id())
 *             .serviceIdentifier(aws_vpclattice_service.example().id())
 *             .priority(10)
 *             .match(ListenerRuleMatchArgs.builder()
 *                 .httpMatch(ListenerRuleMatchHttpMatchArgs.builder()
 *                     .pathMatch(ListenerRuleMatchHttpMatchPathMatchArgs.builder()
 *                         .caseSensitive(false)
 *                         .match(ListenerRuleMatchHttpMatchPathMatchMatchArgs.builder()
 *                             .exact("/example-path")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .action(ListenerRuleActionArgs.builder()
 *                 .fixedResponse(ListenerRuleActionFixedResponseArgs.builder()
 *                     .statusCode(404)
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import VPC Lattice Listener Rule using the `example_id_arg`. For example:
 * ```sh
 *  $ pulumi import aws:vpclattice/listenerRule:ListenerRule example rft-8012925589
 * ```
 * @property action The action for the listener rule.
 * @property listenerIdentifier The ID or Amazon Resource Name (ARN) of the listener.
 * @property match The rule match.
 * @property name The name of the rule. The name must be unique within the listener. The valid characters are a-z, 0-9, and hyphens (-). You can't use a hyphen as the first or last character, or immediately after another hyphen.
 * @property priority The priority assigned to the rule. Each rule for a specific listener must have a unique priority. The lower the priority number the higher the priority.
 * The following arguments are optional:
 * @property serviceIdentifier The ID or Amazon Resource Identifier (ARN) of the service.
 * @property tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class ListenerRuleArgs(
    public val action: Output<ListenerRuleActionArgs>? = null,
    public val listenerIdentifier: Output<String>? = null,
    public val match: Output<ListenerRuleMatchArgs>? = null,
    public val name: Output<String>? = null,
    public val priority: Output<Int>? = null,
    public val serviceIdentifier: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.vpclattice.ListenerRuleArgs> {
    override fun toJava(): com.pulumi.aws.vpclattice.ListenerRuleArgs =
        com.pulumi.aws.vpclattice.ListenerRuleArgs.builder()
            .action(action?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .listenerIdentifier(listenerIdentifier?.applyValue({ args0 -> args0 }))
            .match(match?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .priority(priority?.applyValue({ args0 -> args0 }))
            .serviceIdentifier(serviceIdentifier?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ListenerRuleArgs].
 */
@PulumiTagMarker
public class ListenerRuleArgsBuilder internal constructor() {
    private var action: Output<ListenerRuleActionArgs>? = null

    private var listenerIdentifier: Output<String>? = null

    private var match: Output<ListenerRuleMatchArgs>? = null

    private var name: Output<String>? = null

    private var priority: Output<Int>? = null

    private var serviceIdentifier: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The action for the listener rule.
     */
    @JvmName("luapxdlfdturtetr")
    public suspend fun action(`value`: Output<ListenerRuleActionArgs>) {
        this.action = value
    }

    /**
     * @param value The ID or Amazon Resource Name (ARN) of the listener.
     */
    @JvmName("hdbgottgmfmxaxov")
    public suspend fun listenerIdentifier(`value`: Output<String>) {
        this.listenerIdentifier = value
    }

    /**
     * @param value The rule match.
     */
    @JvmName("mbqkmymbqpmuflao")
    public suspend fun match(`value`: Output<ListenerRuleMatchArgs>) {
        this.match = value
    }

    /**
     * @param value The name of the rule. The name must be unique within the listener. The valid characters are a-z, 0-9, and hyphens (-). You can't use a hyphen as the first or last character, or immediately after another hyphen.
     */
    @JvmName("urdtjftuswuhathx")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The priority assigned to the rule. Each rule for a specific listener must have a unique priority. The lower the priority number the higher the priority.
     * The following arguments are optional:
     */
    @JvmName("jtodknoamceaduur")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value The ID or Amazon Resource Identifier (ARN) of the service.
     */
    @JvmName("clrhhstvcojtemgv")
    public suspend fun serviceIdentifier(`value`: Output<String>) {
        this.serviceIdentifier = value
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("goqrokgmidmasuuh")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The action for the listener rule.
     */
    @JvmName("nbswonheyarpmtxp")
    public suspend fun action(`value`: ListenerRuleActionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param argument The action for the listener rule.
     */
    @JvmName("qykccrocysqgxnfo")
    public suspend fun action(argument: suspend ListenerRuleActionArgsBuilder.() -> Unit) {
        val toBeMapped = ListenerRuleActionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.action = mapped
    }

    /**
     * @param value The ID or Amazon Resource Name (ARN) of the listener.
     */
    @JvmName("qoqrrmqedhhtnitc")
    public suspend fun listenerIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.listenerIdentifier = mapped
    }

    /**
     * @param value The rule match.
     */
    @JvmName("ccitgvjohannlykk")
    public suspend fun match(`value`: ListenerRuleMatchArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.match = mapped
    }

    /**
     * @param argument The rule match.
     */
    @JvmName("upaivgvarfuwwjwa")
    public suspend fun match(argument: suspend ListenerRuleMatchArgsBuilder.() -> Unit) {
        val toBeMapped = ListenerRuleMatchArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.match = mapped
    }

    /**
     * @param value The name of the rule. The name must be unique within the listener. The valid characters are a-z, 0-9, and hyphens (-). You can't use a hyphen as the first or last character, or immediately after another hyphen.
     */
    @JvmName("asexjyyrugnxlgky")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The priority assigned to the rule. Each rule for a specific listener must have a unique priority. The lower the priority number the higher the priority.
     * The following arguments are optional:
     */
    @JvmName("yukcwhpokpbtvfls")
    public suspend fun priority(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value The ID or Amazon Resource Identifier (ARN) of the service.
     */
    @JvmName("iwmymfquttrvflpa")
    public suspend fun serviceIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceIdentifier = mapped
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("gxkkbqywktowsqge")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("hcjhsmyvvbvsrcha")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ListenerRuleArgs = ListenerRuleArgs(
        action = action,
        listenerIdentifier = listenerIdentifier,
        match = match,
        name = name,
        priority = priority,
        serviceIdentifier = serviceIdentifier,
        tags = tags,
    )
}
