@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.vpclattice.kotlin

import com.pulumi.aws.vpclattice.ResourcePolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS VPC Lattice Resource Policy.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.inputs.GetPartitionArgs;
 * import com.pulumi.aws.vpclattice.ServiceNetwork;
 * import com.pulumi.aws.vpclattice.ResourcePolicy;
 * import com.pulumi.aws.vpclattice.ResourcePolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var currentCallerIdentity = AwsFunctions.getCallerIdentity();
 *         final var currentPartition = AwsFunctions.getPartition();
 *         var exampleServiceNetwork = new ServiceNetwork("exampleServiceNetwork");
 *         var exampleResourcePolicy = new ResourcePolicy("exampleResourcePolicy", ResourcePolicyArgs.builder()
 *             .resourceArn(exampleServiceNetwork.arn())
 *             .policy(exampleServiceNetwork.arn().applyValue(arn -> serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Sid", "test-pol-principals-6"),
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Principal", jsonObject(
 *                             jsonProperty("AWS", String.format("arn:%s:iam::%s:root", currentPartition.applyValue(getPartitionResult -> getPartitionResult.partition()),currentCallerIdentity.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId())))
 *                         )),
 *                         jsonProperty("Action", jsonArray(
 *                             "vpc-lattice:CreateServiceNetworkVpcAssociation",
 *                             "vpc-lattice:CreateServiceNetworkServiceAssociation",
 *                             "vpc-lattice:GetServiceNetwork"
 *                         )),
 *                         jsonProperty("Resource", arn)
 *                     )))
 *                 ))))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import VPC Lattice Resource Policy using the `resource_arn`. For example:
 * ```sh
 *  $ pulumi import aws:vpclattice/resourcePolicy:ResourcePolicy example rft-8012925589
 * ```
 * @property policy An IAM policy. The policy string in JSON must not contain newlines or blank lines.
 * @property resourceArn The ID or Amazon Resource Name (ARN) of the service network or service for which the policy is created.
 */
public data class ResourcePolicyArgs(
    public val policy: Output<String>? = null,
    public val resourceArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.vpclattice.ResourcePolicyArgs> {
    override fun toJava(): com.pulumi.aws.vpclattice.ResourcePolicyArgs =
        com.pulumi.aws.vpclattice.ResourcePolicyArgs.builder()
            .policy(policy?.applyValue({ args0 -> args0 }))
            .resourceArn(resourceArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResourcePolicyArgs].
 */
@PulumiTagMarker
public class ResourcePolicyArgsBuilder internal constructor() {
    private var policy: Output<String>? = null

    private var resourceArn: Output<String>? = null

    /**
     * @param value An IAM policy. The policy string in JSON must not contain newlines or blank lines.
     */
    @JvmName("hkkfpoonnqhrgcmq")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value The ID or Amazon Resource Name (ARN) of the service network or service for which the policy is created.
     */
    @JvmName("sjltsfgrxifxpdnb")
    public suspend fun resourceArn(`value`: Output<String>) {
        this.resourceArn = value
    }

    /**
     * @param value An IAM policy. The policy string in JSON must not contain newlines or blank lines.
     */
    @JvmName("vbwsyeupbihcxagb")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param value The ID or Amazon Resource Name (ARN) of the service network or service for which the policy is created.
     */
    @JvmName("pyqlqyejrekvhqvk")
    public suspend fun resourceArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceArn = mapped
    }

    internal fun build(): ResourcePolicyArgs = ResourcePolicyArgs(
        policy = policy,
        resourceArn = resourceArn,
    )
}
