@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.vpclattice.kotlin

import com.pulumi.aws.vpclattice.ServiceNetworkServiceAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS VPC Lattice Service Network Service Association.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.vpclattice.ServiceNetworkServiceAssociation;
 * import com.pulumi.aws.vpclattice.ServiceNetworkServiceAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ServiceNetworkServiceAssociation("example", ServiceNetworkServiceAssociationArgs.builder()
 *             .serviceIdentifier(aws_vpclattice_service.example().id())
 *             .serviceNetworkIdentifier(aws_vpclattice_service_network.example().id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import VPC Lattice Service Network Service Association using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:vpclattice/serviceNetworkServiceAssociation:ServiceNetworkServiceAssociation example snsa-05e2474658a88f6ba
 * ```
 * @property serviceIdentifier The ID or Amazon Resource Identifier (ARN) of the service.
 * @property serviceNetworkIdentifier The ID or Amazon Resource Identifier (ARN) of the service network. You must use the ARN if the resources specified in the operation are in different accounts.
 * The following arguments are optional:
 * @property tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class ServiceNetworkServiceAssociationArgs(
    public val serviceIdentifier: Output<String>? = null,
    public val serviceNetworkIdentifier: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.vpclattice.ServiceNetworkServiceAssociationArgs> {
    override fun toJava(): com.pulumi.aws.vpclattice.ServiceNetworkServiceAssociationArgs =
        com.pulumi.aws.vpclattice.ServiceNetworkServiceAssociationArgs.builder()
            .serviceIdentifier(serviceIdentifier?.applyValue({ args0 -> args0 }))
            .serviceNetworkIdentifier(serviceNetworkIdentifier?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ServiceNetworkServiceAssociationArgs].
 */
@PulumiTagMarker
public class ServiceNetworkServiceAssociationArgsBuilder internal constructor() {
    private var serviceIdentifier: Output<String>? = null

    private var serviceNetworkIdentifier: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The ID or Amazon Resource Identifier (ARN) of the service.
     */
    @JvmName("yyvrgdpcjeablkgl")
    public suspend fun serviceIdentifier(`value`: Output<String>) {
        this.serviceIdentifier = value
    }

    /**
     * @param value The ID or Amazon Resource Identifier (ARN) of the service network. You must use the ARN if the resources specified in the operation are in different accounts.
     * The following arguments are optional:
     */
    @JvmName("qfkbbpiwivfknjqf")
    public suspend fun serviceNetworkIdentifier(`value`: Output<String>) {
        this.serviceNetworkIdentifier = value
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mtsvrfymtvvodrry")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The ID or Amazon Resource Identifier (ARN) of the service.
     */
    @JvmName("lhwgfbruomcctnej")
    public suspend fun serviceIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceIdentifier = mapped
    }

    /**
     * @param value The ID or Amazon Resource Identifier (ARN) of the service network. You must use the ARN if the resources specified in the operation are in different accounts.
     * The following arguments are optional:
     */
    @JvmName("mpynwmwlbquufmrs")
    public suspend fun serviceNetworkIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceNetworkIdentifier = mapped
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("nyrhjkmldgmlqrkt")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xlccctmschnaqytt")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ServiceNetworkServiceAssociationArgs = ServiceNetworkServiceAssociationArgs(
        serviceIdentifier = serviceIdentifier,
        serviceNetworkIdentifier = serviceNetworkIdentifier,
        tags = tags,
    )
}
