@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.vpclattice.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [ServiceNetworkVpcAssociation].
 */
@PulumiTagMarker
public class ServiceNetworkVpcAssociationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServiceNetworkVpcAssociationArgs = ServiceNetworkVpcAssociationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServiceNetworkVpcAssociationArgsBuilder.() -> Unit) {
        val builder = ServiceNetworkVpcAssociationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ServiceNetworkVpcAssociation {
        val builtJavaResource =
            com.pulumi.aws.vpclattice.ServiceNetworkVpcAssociation(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ServiceNetworkVpcAssociation(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS VPC Lattice Service Network VPC Association.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.vpclattice.ServiceNetworkVpcAssociation;
 * import com.pulumi.aws.vpclattice.ServiceNetworkVpcAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ServiceNetworkVpcAssociation("example", ServiceNetworkVpcAssociationArgs.builder()
 *             .vpcIdentifier(aws_vpc.example().id())
 *             .serviceNetworkIdentifier(aws_vpclattice_service_network.example().id())
 *             .securityGroupIds(aws_security_group.example().id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import VPC Lattice Service Network VPC Association using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:vpclattice/serviceNetworkVpcAssociation:ServiceNetworkVpcAssociation example snsa-05e2474658a88f6ba
 * ```
 *
 */
public class ServiceNetworkVpcAssociation internal constructor(
    override val javaResource: com.pulumi.aws.vpclattice.ServiceNetworkVpcAssociation,
) : KotlinCustomResource(javaResource, ServiceNetworkVpcAssociationMapper) {
    /**
     * The ARN of the Association.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The account that created the association.
     */
    public val createdBy: Output<String>
        get() = javaResource.createdBy().applyValue({ args0 -> args0 })

    /**
     * The IDs of the security groups.
     */
    public val securityGroupIds: Output<List<String>>?
        get() = javaResource.securityGroupIds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The ID or Amazon Resource Identifier (ARN) of the service network. You must use the ARN if the resources specified in the operation are in different accounts.
     * The following arguments are optional:
     */
    public val serviceNetworkIdentifier: Output<String>
        get() = javaResource.serviceNetworkIdentifier().applyValue({ args0 -> args0 })

    /**
     * The operations status. Valid Values are CREATE_IN_PROGRESS | ACTIVE | DELETE_IN_PROGRESS | CREATE_FAILED | DELETE_FAILED
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The ID of the VPC.
     */
    public val vpcIdentifier: Output<String>
        get() = javaResource.vpcIdentifier().applyValue({ args0 -> args0 })
}

public object ServiceNetworkVpcAssociationMapper : ResourceMapper<ServiceNetworkVpcAssociation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.vpclattice.ServiceNetworkVpcAssociation::class == javaResource::class

    override fun map(javaResource: Resource): ServiceNetworkVpcAssociation =
        ServiceNetworkVpcAssociation(
            javaResource as
                com.pulumi.aws.vpclattice.ServiceNetworkVpcAssociation,
        )
}

/**
 * @see [ServiceNetworkVpcAssociation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ServiceNetworkVpcAssociation].
 */
public suspend fun serviceNetworkVpcAssociation(
    name: String,
    block: suspend ServiceNetworkVpcAssociationResourceBuilder.() -> Unit,
):
    ServiceNetworkVpcAssociation {
    val builder = ServiceNetworkVpcAssociationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ServiceNetworkVpcAssociation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun serviceNetworkVpcAssociation(name: String): ServiceNetworkVpcAssociation {
    val builder = ServiceNetworkVpcAssociationResourceBuilder()
    builder.name(name)
    return builder.build()
}
