@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.vpclattice.kotlin

import com.pulumi.aws.vpclattice.kotlin.outputs.TargetGroupConfig
import com.pulumi.aws.vpclattice.kotlin.outputs.TargetGroupConfig.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [TargetGroup].
 */
@PulumiTagMarker
public class TargetGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TargetGroupArgs = TargetGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TargetGroupArgsBuilder.() -> Unit) {
        val builder = TargetGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): TargetGroup {
        val builtJavaResource = com.pulumi.aws.vpclattice.TargetGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return TargetGroup(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS VPC Lattice Target Group.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.vpclattice.TargetGroup;
 * import com.pulumi.aws.vpclattice.TargetGroupArgs;
 * import com.pulumi.aws.vpclattice.inputs.TargetGroupConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new TargetGroup("example", TargetGroupArgs.builder()
 *             .type("INSTANCE")
 *             .config(TargetGroupConfigArgs.builder()
 *                 .vpcIdentifier(aws_vpc.example().id())
 *                 .port(443)
 *                 .protocol("HTTPS")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Basic usage with Health check
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.vpclattice.TargetGroup;
 * import com.pulumi.aws.vpclattice.TargetGroupArgs;
 * import com.pulumi.aws.vpclattice.inputs.TargetGroupConfigArgs;
 * import com.pulumi.aws.vpclattice.inputs.TargetGroupConfigHealthCheckArgs;
 * import com.pulumi.aws.vpclattice.inputs.TargetGroupConfigHealthCheckMatcherArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new TargetGroup("example", TargetGroupArgs.builder()
 *             .type("IP")
 *             .config(TargetGroupConfigArgs.builder()
 *                 .vpcIdentifier(aws_vpc.example().id())
 *                 .ipAddressType("IPV4")
 *                 .port(443)
 *                 .protocol("HTTPS")
 *                 .protocolVersion("HTTP1")
 *                 .healthCheck(TargetGroupConfigHealthCheckArgs.builder()
 *                     .enabled(true)
 *                     .healthCheckIntervalSeconds(20)
 *                     .healthCheckTimeoutSeconds(10)
 *                     .healthyThresholdCount(7)
 *                     .unhealthyThresholdCount(3)
 *                     .matcher(TargetGroupConfigHealthCheckMatcherArgs.builder()
 *                         .value("200-299")
 *                         .build())
 *                     .path("/instance")
 *                     .port(80)
 *                     .protocol("HTTP")
 *                     .protocolVersion("HTTP1")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### ALB
 * If the type is ALB, `health_check` block is not supported.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.vpclattice.TargetGroup;
 * import com.pulumi.aws.vpclattice.TargetGroupArgs;
 * import com.pulumi.aws.vpclattice.inputs.TargetGroupConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new TargetGroup("example", TargetGroupArgs.builder()
 *             .type("ALB")
 *             .config(TargetGroupConfigArgs.builder()
 *                 .vpcIdentifier(aws_vpc.example().id())
 *                 .port(443)
 *                 .protocol("HTTPS")
 *                 .protocolVersion("HTTP1")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Lambda
 * If the type is Lambda, `config` block is not supported.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.vpclattice.TargetGroup;
 * import com.pulumi.aws.vpclattice.TargetGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new TargetGroup("example", TargetGroupArgs.builder()
 *             .type("LAMBDA")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import VPC Lattice Target Group using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:vpclattice/targetGroup:TargetGroup example tg-0c11d4dc16ed96bdb
 * ```
 *
 */
public class TargetGroup internal constructor(
    override val javaResource: com.pulumi.aws.vpclattice.TargetGroup,
) : KotlinCustomResource(javaResource, TargetGroupMapper) {
    /**
     * ARN of the target group.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The target group configuration.
     */
    public val config: Output<TargetGroupConfig>?
        get() = javaResource.config().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The name of the target group. The name must be unique within the account. The valid characters are a-z, 0-9, and hyphens (-). You can't use a hyphen as the first or last character, or immediately after another hyphen.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Status of the target group.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The type of target group. Valid Values are `IP` | `LAMBDA` | `INSTANCE` | `ALB`
     * The following arguments are optional:
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object TargetGroupMapper : ResourceMapper<TargetGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.vpclattice.TargetGroup::class == javaResource::class

    override fun map(javaResource: Resource): TargetGroup = TargetGroup(
        javaResource as
            com.pulumi.aws.vpclattice.TargetGroup,
    )
}

/**
 * @see [TargetGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TargetGroup].
 */
public suspend fun targetGroup(name: String, block: suspend TargetGroupResourceBuilder.() -> Unit):
    TargetGroup {
    val builder = TargetGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TargetGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun targetGroup(name: String): TargetGroup {
    val builder = TargetGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
