@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.vpclattice.kotlin

import com.pulumi.aws.vpclattice.TargetGroupArgs.builder
import com.pulumi.aws.vpclattice.kotlin.inputs.TargetGroupConfigArgs
import com.pulumi.aws.vpclattice.kotlin.inputs.TargetGroupConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS VPC Lattice Target Group.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.vpclattice.TargetGroup;
 * import com.pulumi.aws.vpclattice.TargetGroupArgs;
 * import com.pulumi.aws.vpclattice.inputs.TargetGroupConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new TargetGroup("example", TargetGroupArgs.builder()
 *             .type("INSTANCE")
 *             .config(TargetGroupConfigArgs.builder()
 *                 .vpcIdentifier(aws_vpc.example().id())
 *                 .port(443)
 *                 .protocol("HTTPS")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Basic usage with Health check
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.vpclattice.TargetGroup;
 * import com.pulumi.aws.vpclattice.TargetGroupArgs;
 * import com.pulumi.aws.vpclattice.inputs.TargetGroupConfigArgs;
 * import com.pulumi.aws.vpclattice.inputs.TargetGroupConfigHealthCheckArgs;
 * import com.pulumi.aws.vpclattice.inputs.TargetGroupConfigHealthCheckMatcherArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new TargetGroup("example", TargetGroupArgs.builder()
 *             .type("IP")
 *             .config(TargetGroupConfigArgs.builder()
 *                 .vpcIdentifier(aws_vpc.example().id())
 *                 .ipAddressType("IPV4")
 *                 .port(443)
 *                 .protocol("HTTPS")
 *                 .protocolVersion("HTTP1")
 *                 .healthCheck(TargetGroupConfigHealthCheckArgs.builder()
 *                     .enabled(true)
 *                     .healthCheckIntervalSeconds(20)
 *                     .healthCheckTimeoutSeconds(10)
 *                     .healthyThresholdCount(7)
 *                     .unhealthyThresholdCount(3)
 *                     .matcher(TargetGroupConfigHealthCheckMatcherArgs.builder()
 *                         .value("200-299")
 *                         .build())
 *                     .path("/instance")
 *                     .port(80)
 *                     .protocol("HTTP")
 *                     .protocolVersion("HTTP1")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### ALB
 * If the type is ALB, `health_check` block is not supported.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.vpclattice.TargetGroup;
 * import com.pulumi.aws.vpclattice.TargetGroupArgs;
 * import com.pulumi.aws.vpclattice.inputs.TargetGroupConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new TargetGroup("example", TargetGroupArgs.builder()
 *             .type("ALB")
 *             .config(TargetGroupConfigArgs.builder()
 *                 .vpcIdentifier(aws_vpc.example().id())
 *                 .port(443)
 *                 .protocol("HTTPS")
 *                 .protocolVersion("HTTP1")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Lambda
 * If the type is Lambda, `config` block is not supported.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.vpclattice.TargetGroup;
 * import com.pulumi.aws.vpclattice.TargetGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new TargetGroup("example", TargetGroupArgs.builder()
 *             .type("LAMBDA")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import VPC Lattice Target Group using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:vpclattice/targetGroup:TargetGroup example tg-0c11d4dc16ed96bdb
 * ```
 * @property config The target group configuration.
 * @property name The name of the target group. The name must be unique within the account. The valid characters are a-z, 0-9, and hyphens (-). You can't use a hyphen as the first or last character, or immediately after another hyphen.
 * @property tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property type The type of target group. Valid Values are `IP` | `LAMBDA` | `INSTANCE` | `ALB`
 * The following arguments are optional:
 */
public data class TargetGroupArgs(
    public val config: Output<TargetGroupConfigArgs>? = null,
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.vpclattice.TargetGroupArgs> {
    override fun toJava(): com.pulumi.aws.vpclattice.TargetGroupArgs =
        com.pulumi.aws.vpclattice.TargetGroupArgs.builder()
            .config(config?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TargetGroupArgs].
 */
@PulumiTagMarker
public class TargetGroupArgsBuilder internal constructor() {
    private var config: Output<TargetGroupConfigArgs>? = null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var type: Output<String>? = null

    /**
     * @param value The target group configuration.
     */
    @JvmName("wtrunqhmadddetrs")
    public suspend fun config(`value`: Output<TargetGroupConfigArgs>) {
        this.config = value
    }

    /**
     * @param value The name of the target group. The name must be unique within the account. The valid characters are a-z, 0-9, and hyphens (-). You can't use a hyphen as the first or last character, or immediately after another hyphen.
     */
    @JvmName("xkhkhstsferrlfba")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("csihgmipgyslqjej")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The type of target group. Valid Values are `IP` | `LAMBDA` | `INSTANCE` | `ALB`
     * The following arguments are optional:
     */
    @JvmName("ulknfinwtsijobrb")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The target group configuration.
     */
    @JvmName("muuexpggkgkymqhv")
    public suspend fun config(`value`: TargetGroupConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.config = mapped
    }

    /**
     * @param argument The target group configuration.
     */
    @JvmName("dfrwmyvltkqgubxu")
    public suspend fun config(argument: suspend TargetGroupConfigArgsBuilder.() -> Unit) {
        val toBeMapped = TargetGroupConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.config = mapped
    }

    /**
     * @param value The name of the target group. The name must be unique within the account. The valid characters are a-z, 0-9, and hyphens (-). You can't use a hyphen as the first or last character, or immediately after another hyphen.
     */
    @JvmName("lnkjnapllwetjiml")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("pufvejovbdyinxve")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("hsohmhywraerfvvv")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The type of target group. Valid Values are `IP` | `LAMBDA` | `INSTANCE` | `ALB`
     * The following arguments are optional:
     */
    @JvmName("exsjkbqgemuejfqs")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): TargetGroupArgs = TargetGroupArgs(
        config = config,
        name = name,
        tags = tags,
        type = type,
    )
}
