@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.vpclattice.kotlin

import com.pulumi.aws.vpclattice.TargetGroupAttachmentArgs.builder
import com.pulumi.aws.vpclattice.kotlin.inputs.TargetGroupAttachmentTargetArgs
import com.pulumi.aws.vpclattice.kotlin.inputs.TargetGroupAttachmentTargetArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides the ability to register a target with an AWS VPC Lattice Target Group.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.vpclattice.TargetGroupAttachment;
 * import com.pulumi.aws.vpclattice.TargetGroupAttachmentArgs;
 * import com.pulumi.aws.vpclattice.inputs.TargetGroupAttachmentTargetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new TargetGroupAttachment("example", TargetGroupAttachmentArgs.builder()
 *             .targetGroupIdentifier(aws_vpclattice_target_group.example().id())
 *             .target(TargetGroupAttachmentTargetArgs.builder()
 *                 .id(aws_lb.example().arn())
 *                 .port(80)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * @property target The target.
 * @property targetGroupIdentifier The ID or Amazon Resource Name (ARN) of the target group.
 */
public data class TargetGroupAttachmentArgs(
    public val target: Output<TargetGroupAttachmentTargetArgs>? = null,
    public val targetGroupIdentifier: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.vpclattice.TargetGroupAttachmentArgs> {
    override fun toJava(): com.pulumi.aws.vpclattice.TargetGroupAttachmentArgs =
        com.pulumi.aws.vpclattice.TargetGroupAttachmentArgs.builder()
            .target(target?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .targetGroupIdentifier(targetGroupIdentifier?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TargetGroupAttachmentArgs].
 */
@PulumiTagMarker
public class TargetGroupAttachmentArgsBuilder internal constructor() {
    private var target: Output<TargetGroupAttachmentTargetArgs>? = null

    private var targetGroupIdentifier: Output<String>? = null

    /**
     * @param value The target.
     */
    @JvmName("ljhdaryeackdvxyb")
    public suspend fun target(`value`: Output<TargetGroupAttachmentTargetArgs>) {
        this.target = value
    }

    /**
     * @param value The ID or Amazon Resource Name (ARN) of the target group.
     */
    @JvmName("emkwpodblnwtpfoh")
    public suspend fun targetGroupIdentifier(`value`: Output<String>) {
        this.targetGroupIdentifier = value
    }

    /**
     * @param value The target.
     */
    @JvmName("qyumrgggcaegfigi")
    public suspend fun target(`value`: TargetGroupAttachmentTargetArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.target = mapped
    }

    /**
     * @param argument The target.
     */
    @JvmName("ohkkdljxtaxqembx")
    public suspend fun target(argument: suspend TargetGroupAttachmentTargetArgsBuilder.() -> Unit) {
        val toBeMapped = TargetGroupAttachmentTargetArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.target = mapped
    }

    /**
     * @param value The ID or Amazon Resource Name (ARN) of the target group.
     */
    @JvmName("srrewedgofgobesx")
    public suspend fun targetGroupIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetGroupIdentifier = mapped
    }

    internal fun build(): TargetGroupAttachmentArgs = TargetGroupAttachmentArgs(
        target = target,
        targetGroupIdentifier = targetGroupIdentifier,
    )
}
