@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.vpclattice.kotlin

import com.pulumi.aws.vpclattice.VpclatticeFunctions.getAuthPolicyPlain
import com.pulumi.aws.vpclattice.VpclatticeFunctions.getListenerPlain
import com.pulumi.aws.vpclattice.VpclatticeFunctions.getResourcePolicyPlain
import com.pulumi.aws.vpclattice.VpclatticeFunctions.getServiceNetworkPlain
import com.pulumi.aws.vpclattice.VpclatticeFunctions.getServicePlain
import com.pulumi.aws.vpclattice.kotlin.inputs.GetAuthPolicyPlainArgs
import com.pulumi.aws.vpclattice.kotlin.inputs.GetAuthPolicyPlainArgsBuilder
import com.pulumi.aws.vpclattice.kotlin.inputs.GetListenerPlainArgs
import com.pulumi.aws.vpclattice.kotlin.inputs.GetListenerPlainArgsBuilder
import com.pulumi.aws.vpclattice.kotlin.inputs.GetResourcePolicyPlainArgs
import com.pulumi.aws.vpclattice.kotlin.inputs.GetResourcePolicyPlainArgsBuilder
import com.pulumi.aws.vpclattice.kotlin.inputs.GetServiceNetworkPlainArgs
import com.pulumi.aws.vpclattice.kotlin.inputs.GetServiceNetworkPlainArgsBuilder
import com.pulumi.aws.vpclattice.kotlin.inputs.GetServicePlainArgs
import com.pulumi.aws.vpclattice.kotlin.inputs.GetServicePlainArgsBuilder
import com.pulumi.aws.vpclattice.kotlin.outputs.GetAuthPolicyResult
import com.pulumi.aws.vpclattice.kotlin.outputs.GetListenerResult
import com.pulumi.aws.vpclattice.kotlin.outputs.GetResourcePolicyResult
import com.pulumi.aws.vpclattice.kotlin.outputs.GetServiceNetworkResult
import com.pulumi.aws.vpclattice.kotlin.outputs.GetServiceResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.vpclattice.kotlin.outputs.GetAuthPolicyResult.Companion.toKotlin as getAuthPolicyResultToKotlin
import com.pulumi.aws.vpclattice.kotlin.outputs.GetListenerResult.Companion.toKotlin as getListenerResultToKotlin
import com.pulumi.aws.vpclattice.kotlin.outputs.GetResourcePolicyResult.Companion.toKotlin as getResourcePolicyResultToKotlin
import com.pulumi.aws.vpclattice.kotlin.outputs.GetServiceNetworkResult.Companion.toKotlin as getServiceNetworkResultToKotlin
import com.pulumi.aws.vpclattice.kotlin.outputs.GetServiceResult.Companion.toKotlin as getServiceResultToKotlin

public object VpclatticeFunctions {
    /**
     * Data source for managing an AWS VPC Lattice Auth Policy.
     * ## Example Usage
     * ### Basic Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.vpclattice.VpclatticeFunctions;
     * import com.pulumi.aws.vpclattice.inputs.GetAuthPolicyArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = VpclatticeFunctions.getAuthPolicy(GetAuthPolicyArgs.builder()
     *             .resourceIdentifier(aws_vpclattice_auth_policy.test().resource_identifier())
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getAuthPolicy.
     * @return A collection of values returned by getAuthPolicy.
     */
    public suspend fun getAuthPolicy(argument: GetAuthPolicyPlainArgs): GetAuthPolicyResult =
        getAuthPolicyResultToKotlin(getAuthPolicyPlain(argument.toJava()).await())

    /**
     * @see [getAuthPolicy].
     * @param policy The auth policy. The policy string in JSON must not contain newlines or blank lines.
     * @param resourceIdentifier The ID or Amazon Resource Name (ARN) of the service network or service for which the policy is created.
     * @param state The state of the auth policy. The auth policy is only active when the auth type is set to AWS_IAM. If you provide a policy, then authentication and authorization decisions are made based on this policy and the client's IAM policy. If the Auth type is NONE, then, any auth policy you provide will remain inactive.
     * @return A collection of values returned by getAuthPolicy.
     */
    public suspend fun getAuthPolicy(
        policy: String? = null,
        resourceIdentifier: String,
        state: String? = null,
    ): GetAuthPolicyResult {
        val argument = GetAuthPolicyPlainArgs(
            policy = policy,
            resourceIdentifier = resourceIdentifier,
            state = state,
        )
        return getAuthPolicyResultToKotlin(getAuthPolicyPlain(argument.toJava()).await())
    }

    /**
     * @see [getAuthPolicy].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;vpclattice&#46;kotlin&#46;inputs&#46;GetAuthPolicyPlainArgs].
     * @return A collection of values returned by getAuthPolicy.
     */
    public suspend fun getAuthPolicy(argument: suspend GetAuthPolicyPlainArgsBuilder.() -> Unit):
        GetAuthPolicyResult {
        val builder = GetAuthPolicyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAuthPolicyResultToKotlin(getAuthPolicyPlain(builtArgument.toJava()).await())
    }

    /**
     * Data source for managing an AWS VPC Lattice Listener.
     * ## Example Usage
     * ### Basic Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.vpclattice.VpclatticeFunctions;
     * import com.pulumi.aws.vpclattice.inputs.GetListenerArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = VpclatticeFunctions.getListener();
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getListener.
     * @return A collection of values returned by getListener.
     */
    public suspend fun getListener(argument: GetListenerPlainArgs): GetListenerResult =
        getListenerResultToKotlin(getListenerPlain(argument.toJava()).await())

    /**
     * @see [getListener].
     * @param listenerIdentifier ID or Amazon Resource Name (ARN) of the listener
     * @param serviceIdentifier ID or Amazon Resource Name (ARN) of the service network
     * @param tags List of tags associated with the listener.
     * @return A collection of values returned by getListener.
     */
    public suspend fun getListener(
        listenerIdentifier: String,
        serviceIdentifier: String,
        tags: Map<String, String>? = null,
    ): GetListenerResult {
        val argument = GetListenerPlainArgs(
            listenerIdentifier = listenerIdentifier,
            serviceIdentifier = serviceIdentifier,
            tags = tags,
        )
        return getListenerResultToKotlin(getListenerPlain(argument.toJava()).await())
    }

    /**
     * @see [getListener].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;vpclattice&#46;kotlin&#46;inputs&#46;GetListenerPlainArgs].
     * @return A collection of values returned by getListener.
     */
    public suspend fun getListener(argument: suspend GetListenerPlainArgsBuilder.() -> Unit):
        GetListenerResult {
        val builder = GetListenerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getListenerResultToKotlin(getListenerPlain(builtArgument.toJava()).await())
    }

    /**
     * Data source for managing an AWS VPC Lattice Resource Policy.
     * ## Example Usage
     * ### Basic Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.vpclattice.VpclatticeFunctions;
     * import com.pulumi.aws.vpclattice.inputs.GetResourcePolicyArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = VpclatticeFunctions.getResourcePolicy(GetResourcePolicyArgs.builder()
     *             .resourceArn(aws_vpclattice_service_network.example().arn())
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getResourcePolicy.
     * @return A collection of values returned by getResourcePolicy.
     */
    public suspend fun getResourcePolicy(argument: GetResourcePolicyPlainArgs):
        GetResourcePolicyResult =
        getResourcePolicyResultToKotlin(getResourcePolicyPlain(argument.toJava()).await())

    /**
     * @see [getResourcePolicy].
     * @param resourceArn Resource ARN of the resource for which a policy is retrieved.
     * @return A collection of values returned by getResourcePolicy.
     */
    public suspend fun getResourcePolicy(resourceArn: String): GetResourcePolicyResult {
        val argument = GetResourcePolicyPlainArgs(
            resourceArn = resourceArn,
        )
        return getResourcePolicyResultToKotlin(getResourcePolicyPlain(argument.toJava()).await())
    }

    /**
     * @see [getResourcePolicy].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;vpclattice&#46;kotlin&#46;inputs&#46;GetResourcePolicyPlainArgs].
     * @return A collection of values returned by getResourcePolicy.
     */
    public suspend
    fun getResourcePolicy(argument: suspend GetResourcePolicyPlainArgsBuilder.() -> Unit):
        GetResourcePolicyResult {
        val builder = GetResourcePolicyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getResourcePolicyResultToKotlin(getResourcePolicyPlain(builtArgument.toJava()).await())
    }

    /**
     * Data source for managing an AWS VPC Lattice Service.
     * ## Example Usage
     * ### Basic Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.vpclattice.VpclatticeFunctions;
     * import com.pulumi.aws.vpclattice.inputs.GetServiceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = VpclatticeFunctions.getService(GetServiceArgs.builder()
     *             .name("example")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getService.
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(argument: GetServicePlainArgs): GetServiceResult =
        getServiceResultToKotlin(getServicePlain(argument.toJava()).await())

    /**
     * @see [getService].
     * @param name Service name.
     * @param serviceIdentifier ID or Amazon Resource Name (ARN) of the service.
     * @param tags List of tags associated with the service.
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(
        name: String? = null,
        serviceIdentifier: String? = null,
        tags: Map<String, String>? = null,
    ): GetServiceResult {
        val argument = GetServicePlainArgs(
            name = name,
            serviceIdentifier = serviceIdentifier,
            tags = tags,
        )
        return getServiceResultToKotlin(getServicePlain(argument.toJava()).await())
    }

    /**
     * @see [getService].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;vpclattice&#46;kotlin&#46;inputs&#46;GetServicePlainArgs].
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(argument: suspend GetServicePlainArgsBuilder.() -> Unit):
        GetServiceResult {
        val builder = GetServicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServiceResultToKotlin(getServicePlain(builtArgument.toJava()).await())
    }

    /**
     * Data source for managing an AWS VPC Lattice Service Network.
     * ## Example Usage
     * ### Basic Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.vpclattice.VpclatticeFunctions;
     * import com.pulumi.aws.vpclattice.inputs.GetServiceNetworkArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = VpclatticeFunctions.getServiceNetwork(GetServiceNetworkArgs.builder()
     *             .serviceNetworkIdentifier("snsa-01112223334445556")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getServiceNetwork.
     * @return A collection of values returned by getServiceNetwork.
     */
    public suspend fun getServiceNetwork(argument: GetServiceNetworkPlainArgs):
        GetServiceNetworkResult =
        getServiceNetworkResultToKotlin(getServiceNetworkPlain(argument.toJava()).await())

    /**
     * @see [getServiceNetwork].
     * @param serviceNetworkIdentifier Identifier of the service network.
     * @param tags
     * @return A collection of values returned by getServiceNetwork.
     */
    public suspend fun getServiceNetwork(
        serviceNetworkIdentifier: String,
        tags: Map<String, String>? =
            null,
    ): GetServiceNetworkResult {
        val argument = GetServiceNetworkPlainArgs(
            serviceNetworkIdentifier = serviceNetworkIdentifier,
            tags = tags,
        )
        return getServiceNetworkResultToKotlin(getServiceNetworkPlain(argument.toJava()).await())
    }

    /**
     * @see [getServiceNetwork].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;vpclattice&#46;kotlin&#46;inputs&#46;GetServiceNetworkPlainArgs].
     * @return A collection of values returned by getServiceNetwork.
     */
    public suspend
    fun getServiceNetwork(argument: suspend GetServiceNetworkPlainArgsBuilder.() -> Unit):
        GetServiceNetworkResult {
        val builder = GetServiceNetworkPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServiceNetworkResultToKotlin(getServiceNetworkPlain(builtArgument.toJava()).await())
    }
}
