@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.vpclattice.kotlin.inputs

import com.pulumi.aws.vpclattice.inputs.GetAuthPolicyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getAuthPolicy.
 * @property policy The auth policy. The policy string in JSON must not contain newlines or blank lines.
 * @property resourceIdentifier The ID or Amazon Resource Name (ARN) of the service network or service for which the policy is created.
 * @property state The state of the auth policy. The auth policy is only active when the auth type is set to AWS_IAM. If you provide a policy, then authentication and authorization decisions are made based on this policy and the client's IAM policy. If the Auth type is NONE, then, any auth policy you provide will remain inactive.
 */
public data class GetAuthPolicyPlainArgs(
    public val policy: String? = null,
    public val resourceIdentifier: String,
    public val state: String? = null,
) : ConvertibleToJava<com.pulumi.aws.vpclattice.inputs.GetAuthPolicyPlainArgs> {
    override fun toJava(): com.pulumi.aws.vpclattice.inputs.GetAuthPolicyPlainArgs =
        com.pulumi.aws.vpclattice.inputs.GetAuthPolicyPlainArgs.builder()
            .policy(policy?.let({ args0 -> args0 }))
            .resourceIdentifier(resourceIdentifier.let({ args0 -> args0 }))
            .state(state?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAuthPolicyPlainArgs].
 */
@PulumiTagMarker
public class GetAuthPolicyPlainArgsBuilder internal constructor() {
    private var policy: String? = null

    private var resourceIdentifier: String? = null

    private var state: String? = null

    /**
     * @param value The auth policy. The policy string in JSON must not contain newlines or blank lines.
     */
    @JvmName("wtumnxmcpbhyvrmf")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.policy = mapped
    }

    /**
     * @param value The ID or Amazon Resource Name (ARN) of the service network or service for which the policy is created.
     */
    @JvmName("axxjccaadedkgjuq")
    public suspend fun resourceIdentifier(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceIdentifier = mapped
    }

    /**
     * @param value The state of the auth policy. The auth policy is only active when the auth type is set to AWS_IAM. If you provide a policy, then authentication and authorization decisions are made based on this policy and the client's IAM policy. If the Auth type is NONE, then, any auth policy you provide will remain inactive.
     */
    @JvmName("dfcvltjxibfynegw")
    public suspend fun state(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.state = mapped
    }

    internal fun build(): GetAuthPolicyPlainArgs = GetAuthPolicyPlainArgs(
        policy = policy,
        resourceIdentifier = resourceIdentifier ?: throw PulumiNullFieldException("resourceIdentifier"),
        state = state,
    )
}
