@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.vpclattice.kotlin.inputs

import com.pulumi.aws.vpclattice.inputs.GetListenerPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getListener.
 * @property listenerIdentifier ID or Amazon Resource Name (ARN) of the listener
 * @property serviceIdentifier ID or Amazon Resource Name (ARN) of the service network
 * @property tags List of tags associated with the listener.
 */
public data class GetListenerPlainArgs(
    public val listenerIdentifier: String,
    public val serviceIdentifier: String,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.vpclattice.inputs.GetListenerPlainArgs> {
    override fun toJava(): com.pulumi.aws.vpclattice.inputs.GetListenerPlainArgs =
        com.pulumi.aws.vpclattice.inputs.GetListenerPlainArgs.builder()
            .listenerIdentifier(listenerIdentifier.let({ args0 -> args0 }))
            .serviceIdentifier(serviceIdentifier.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetListenerPlainArgs].
 */
@PulumiTagMarker
public class GetListenerPlainArgsBuilder internal constructor() {
    private var listenerIdentifier: String? = null

    private var serviceIdentifier: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value ID or Amazon Resource Name (ARN) of the listener
     */
    @JvmName("tsxjiumbenatosko")
    public suspend fun listenerIdentifier(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.listenerIdentifier = mapped
    }

    /**
     * @param value ID or Amazon Resource Name (ARN) of the service network
     */
    @JvmName("iwmrdowcrcsqksou")
    public suspend fun serviceIdentifier(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceIdentifier = mapped
    }

    /**
     * @param value List of tags associated with the listener.
     */
    @JvmName("xfppewrijbjbfwen")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values List of tags associated with the listener.
     */
    @JvmName("kvofjpvbafnrxydj")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetListenerPlainArgs = GetListenerPlainArgs(
        listenerIdentifier = listenerIdentifier ?: throw PulumiNullFieldException("listenerIdentifier"),
        serviceIdentifier = serviceIdentifier ?: throw PulumiNullFieldException("serviceIdentifier"),
        tags = tags,
    )
}
