@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.vpclattice.kotlin.inputs

import com.pulumi.aws.vpclattice.inputs.GetServiceNetworkPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getServiceNetwork.
 * @property serviceNetworkIdentifier Identifier of the service network.
 * @property tags
 */
public data class GetServiceNetworkPlainArgs(
    public val serviceNetworkIdentifier: String,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.vpclattice.inputs.GetServiceNetworkPlainArgs> {
    override fun toJava(): com.pulumi.aws.vpclattice.inputs.GetServiceNetworkPlainArgs =
        com.pulumi.aws.vpclattice.inputs.GetServiceNetworkPlainArgs.builder()
            .serviceNetworkIdentifier(serviceNetworkIdentifier.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetServiceNetworkPlainArgs].
 */
@PulumiTagMarker
public class GetServiceNetworkPlainArgsBuilder internal constructor() {
    private var serviceNetworkIdentifier: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Identifier of the service network.
     */
    @JvmName("idbpwtjdnfwednpj")
    public suspend fun serviceNetworkIdentifier(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceNetworkIdentifier = mapped
    }

    /**
     * @param value
     */
    @JvmName("ejrmyoljcmfgglhk")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values
     */
    @JvmName("gflrndqoolktmdpq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetServiceNetworkPlainArgs = GetServiceNetworkPlainArgs(
        serviceNetworkIdentifier = serviceNetworkIdentifier ?: throw
            PulumiNullFieldException("serviceNetworkIdentifier"),
        tags = tags,
    )
}
