@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.vpclattice.kotlin.inputs

import com.pulumi.aws.vpclattice.inputs.GetServicePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getService.
 * @property name Service name.
 * @property serviceIdentifier ID or Amazon Resource Name (ARN) of the service.
 * @property tags List of tags associated with the service.
 */
public data class GetServicePlainArgs(
    public val name: String? = null,
    public val serviceIdentifier: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.vpclattice.inputs.GetServicePlainArgs> {
    override fun toJava(): com.pulumi.aws.vpclattice.inputs.GetServicePlainArgs =
        com.pulumi.aws.vpclattice.inputs.GetServicePlainArgs.builder()
            .name(name?.let({ args0 -> args0 }))
            .serviceIdentifier(serviceIdentifier?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetServicePlainArgs].
 */
@PulumiTagMarker
public class GetServicePlainArgsBuilder internal constructor() {
    private var name: String? = null

    private var serviceIdentifier: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Service name.
     */
    @JvmName("veklobsxmqnuemgv")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value ID or Amazon Resource Name (ARN) of the service.
     */
    @JvmName("kugijfjrrtlxobtf")
    public suspend fun serviceIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.serviceIdentifier = mapped
    }

    /**
     * @param value List of tags associated with the service.
     */
    @JvmName("trmvroopojdskfhr")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values List of tags associated with the service.
     */
    @JvmName("gmhccjfjieqimhon")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetServicePlainArgs = GetServicePlainArgs(
        name = name,
        serviceIdentifier = serviceIdentifier,
        tags = tags,
    )
}
