@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.vpclattice.kotlin.inputs

import com.pulumi.aws.vpclattice.inputs.ListenerDefaultActionFixedResponseArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property statusCode Custom HTTP status code to return, e.g. a 404 response code. See [Listeners](https://docs.aws.amazon.com/vpc-lattice/latest/ug/listeners.html) in the AWS documentation for a list of supported codes.
 */
public data class ListenerDefaultActionFixedResponseArgs(
    public val statusCode: Output<Int>,
) : ConvertibleToJava<com.pulumi.aws.vpclattice.inputs.ListenerDefaultActionFixedResponseArgs> {
    override fun toJava(): com.pulumi.aws.vpclattice.inputs.ListenerDefaultActionFixedResponseArgs =
        com.pulumi.aws.vpclattice.inputs.ListenerDefaultActionFixedResponseArgs.builder()
            .statusCode(statusCode.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ListenerDefaultActionFixedResponseArgs].
 */
@PulumiTagMarker
public class ListenerDefaultActionFixedResponseArgsBuilder internal constructor() {
    private var statusCode: Output<Int>? = null

    /**
     * @param value Custom HTTP status code to return, e.g. a 404 response code. See [Listeners](https://docs.aws.amazon.com/vpc-lattice/latest/ug/listeners.html) in the AWS documentation for a list of supported codes.
     */
    @JvmName("nnwmnsjqintlfeok")
    public suspend fun statusCode(`value`: Output<Int>) {
        this.statusCode = value
    }

    /**
     * @param value Custom HTTP status code to return, e.g. a 404 response code. See [Listeners](https://docs.aws.amazon.com/vpc-lattice/latest/ug/listeners.html) in the AWS documentation for a list of supported codes.
     */
    @JvmName("uapuhfhdxwotwnvv")
    public suspend fun statusCode(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.statusCode = mapped
    }

    internal fun build(): ListenerDefaultActionFixedResponseArgs =
        ListenerDefaultActionFixedResponseArgs(
            statusCode = statusCode ?: throw PulumiNullFieldException("statusCode"),
        )
}
