@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.vpclattice.kotlin.inputs

import com.pulumi.aws.vpclattice.inputs.ListenerDefaultActionForwardArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property targetGroups One or more target group blocks.
 */
public data class ListenerDefaultActionForwardArgs(
    public val targetGroups: Output<List<ListenerDefaultActionForwardTargetGroupArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.vpclattice.inputs.ListenerDefaultActionForwardArgs> {
    override fun toJava(): com.pulumi.aws.vpclattice.inputs.ListenerDefaultActionForwardArgs =
        com.pulumi.aws.vpclattice.inputs.ListenerDefaultActionForwardArgs.builder()
            .targetGroups(
                targetGroups?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ListenerDefaultActionForwardArgs].
 */
@PulumiTagMarker
public class ListenerDefaultActionForwardArgsBuilder internal constructor() {
    private var targetGroups: Output<List<ListenerDefaultActionForwardTargetGroupArgs>>? = null

    /**
     * @param value One or more target group blocks.
     */
    @JvmName("muxreupyaxahiepy")
    public suspend
    fun targetGroups(`value`: Output<List<ListenerDefaultActionForwardTargetGroupArgs>>) {
        this.targetGroups = value
    }

    @JvmName("atlopfnwhatdfabo")
    public suspend fun targetGroups(
        vararg
        values: Output<ListenerDefaultActionForwardTargetGroupArgs>,
    ) {
        this.targetGroups = Output.all(values.asList())
    }

    /**
     * @param values One or more target group blocks.
     */
    @JvmName("hbgagrweloyrrsii")
    public suspend
    fun targetGroups(values: List<Output<ListenerDefaultActionForwardTargetGroupArgs>>) {
        this.targetGroups = Output.all(values)
    }

    /**
     * @param value One or more target group blocks.
     */
    @JvmName("fefrjddhwmduftcw")
    public suspend fun targetGroups(`value`: List<ListenerDefaultActionForwardTargetGroupArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetGroups = mapped
    }

    /**
     * @param argument One or more target group blocks.
     */
    @JvmName("bxcexintptkcntib")
    public suspend
    fun targetGroups(argument: List<suspend ListenerDefaultActionForwardTargetGroupArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ListenerDefaultActionForwardTargetGroupArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.targetGroups = mapped
    }

    /**
     * @param argument One or more target group blocks.
     */
    @JvmName("npxybbenhosiptpr")
    public suspend fun targetGroups(
        vararg
        argument: suspend ListenerDefaultActionForwardTargetGroupArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ListenerDefaultActionForwardTargetGroupArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.targetGroups = mapped
    }

    /**
     * @param argument One or more target group blocks.
     */
    @JvmName("alrfdgsflyfaqbga")
    public suspend
    fun targetGroups(argument: suspend ListenerDefaultActionForwardTargetGroupArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ListenerDefaultActionForwardTargetGroupArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.targetGroups = mapped
    }

    /**
     * @param values One or more target group blocks.
     */
    @JvmName("nvgcqbjdprwadkol")
    public suspend fun targetGroups(vararg values: ListenerDefaultActionForwardTargetGroupArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetGroups = mapped
    }

    internal fun build(): ListenerDefaultActionForwardArgs = ListenerDefaultActionForwardArgs(
        targetGroups = targetGroups,
    )
}
