@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.vpclattice.kotlin.inputs

import com.pulumi.aws.vpclattice.inputs.ListenerRuleActionFixedResponseArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property statusCode The HTTP response code.
 */
public data class ListenerRuleActionFixedResponseArgs(
    public val statusCode: Output<Int>,
) : ConvertibleToJava<com.pulumi.aws.vpclattice.inputs.ListenerRuleActionFixedResponseArgs> {
    override fun toJava(): com.pulumi.aws.vpclattice.inputs.ListenerRuleActionFixedResponseArgs =
        com.pulumi.aws.vpclattice.inputs.ListenerRuleActionFixedResponseArgs.builder()
            .statusCode(statusCode.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ListenerRuleActionFixedResponseArgs].
 */
@PulumiTagMarker
public class ListenerRuleActionFixedResponseArgsBuilder internal constructor() {
    private var statusCode: Output<Int>? = null

    /**
     * @param value The HTTP response code.
     */
    @JvmName("ursqwjfxhjropkob")
    public suspend fun statusCode(`value`: Output<Int>) {
        this.statusCode = value
    }

    /**
     * @param value The HTTP response code.
     */
    @JvmName("mcqgmxpyxvsbtdif")
    public suspend fun statusCode(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.statusCode = mapped
    }

    internal fun build(): ListenerRuleActionFixedResponseArgs = ListenerRuleActionFixedResponseArgs(
        statusCode = statusCode ?: throw PulumiNullFieldException("statusCode"),
    )
}
