@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.vpclattice.kotlin.inputs

import com.pulumi.aws.vpclattice.inputs.ListenerRuleActionForwardArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property targetGroups The target groups. Traffic matching the rule is forwarded to the specified target groups. With forward actions, you can assign a weight that controls the prioritization and selection of each target group. This means that requests are distributed to individual target groups based on their weights. For example, if two target groups have the same weight, each target group receives half of the traffic.
 * The default value is 1 with maximum number of 2. If only one target group is provided, there is no need to set the weight; 100% of traffic will go to that target group.
 */
public data class ListenerRuleActionForwardArgs(
    public val targetGroups: Output<List<ListenerRuleActionForwardTargetGroupArgs>>,
) : ConvertibleToJava<com.pulumi.aws.vpclattice.inputs.ListenerRuleActionForwardArgs> {
    override fun toJava(): com.pulumi.aws.vpclattice.inputs.ListenerRuleActionForwardArgs =
        com.pulumi.aws.vpclattice.inputs.ListenerRuleActionForwardArgs.builder()
            .targetGroups(
                targetGroups.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ListenerRuleActionForwardArgs].
 */
@PulumiTagMarker
public class ListenerRuleActionForwardArgsBuilder internal constructor() {
    private var targetGroups: Output<List<ListenerRuleActionForwardTargetGroupArgs>>? = null

    /**
     * @param value The target groups. Traffic matching the rule is forwarded to the specified target groups. With forward actions, you can assign a weight that controls the prioritization and selection of each target group. This means that requests are distributed to individual target groups based on their weights. For example, if two target groups have the same weight, each target group receives half of the traffic.
     * The default value is 1 with maximum number of 2. If only one target group is provided, there is no need to set the weight; 100% of traffic will go to that target group.
     */
    @JvmName("gyesjdmeifnilxru")
    public suspend fun targetGroups(`value`: Output<List<ListenerRuleActionForwardTargetGroupArgs>>) {
        this.targetGroups = value
    }

    @JvmName("tsokmqhapkuuxpgu")
    public suspend fun targetGroups(vararg values: Output<ListenerRuleActionForwardTargetGroupArgs>) {
        this.targetGroups = Output.all(values.asList())
    }

    /**
     * @param values The target groups. Traffic matching the rule is forwarded to the specified target groups. With forward actions, you can assign a weight that controls the prioritization and selection of each target group. This means that requests are distributed to individual target groups based on their weights. For example, if two target groups have the same weight, each target group receives half of the traffic.
     * The default value is 1 with maximum number of 2. If only one target group is provided, there is no need to set the weight; 100% of traffic will go to that target group.
     */
    @JvmName("ejsavstpbhgqjyil")
    public suspend fun targetGroups(values: List<Output<ListenerRuleActionForwardTargetGroupArgs>>) {
        this.targetGroups = Output.all(values)
    }

    /**
     * @param value The target groups. Traffic matching the rule is forwarded to the specified target groups. With forward actions, you can assign a weight that controls the prioritization and selection of each target group. This means that requests are distributed to individual target groups based on their weights. For example, if two target groups have the same weight, each target group receives half of the traffic.
     * The default value is 1 with maximum number of 2. If only one target group is provided, there is no need to set the weight; 100% of traffic will go to that target group.
     */
    @JvmName("hhsgqjnrigsluqog")
    public suspend fun targetGroups(`value`: List<ListenerRuleActionForwardTargetGroupArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetGroups = mapped
    }

    /**
     * @param argument The target groups. Traffic matching the rule is forwarded to the specified target groups. With forward actions, you can assign a weight that controls the prioritization and selection of each target group. This means that requests are distributed to individual target groups based on their weights. For example, if two target groups have the same weight, each target group receives half of the traffic.
     * The default value is 1 with maximum number of 2. If only one target group is provided, there is no need to set the weight; 100% of traffic will go to that target group.
     */
    @JvmName("vptqvvaymrrmyorf")
    public suspend
    fun targetGroups(argument: List<suspend ListenerRuleActionForwardTargetGroupArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ListenerRuleActionForwardTargetGroupArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.targetGroups = mapped
    }

    /**
     * @param argument The target groups. Traffic matching the rule is forwarded to the specified target groups. With forward actions, you can assign a weight that controls the prioritization and selection of each target group. This means that requests are distributed to individual target groups based on their weights. For example, if two target groups have the same weight, each target group receives half of the traffic.
     * The default value is 1 with maximum number of 2. If only one target group is provided, there is no need to set the weight; 100% of traffic will go to that target group.
     */
    @JvmName("kqgruguyikxspkek")
    public suspend fun targetGroups(
        vararg
        argument: suspend ListenerRuleActionForwardTargetGroupArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ListenerRuleActionForwardTargetGroupArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.targetGroups = mapped
    }

    /**
     * @param argument The target groups. Traffic matching the rule is forwarded to the specified target groups. With forward actions, you can assign a weight that controls the prioritization and selection of each target group. This means that requests are distributed to individual target groups based on their weights. For example, if two target groups have the same weight, each target group receives half of the traffic.
     * The default value is 1 with maximum number of 2. If only one target group is provided, there is no need to set the weight; 100% of traffic will go to that target group.
     */
    @JvmName("iebsvlvbeiurajsl")
    public suspend
    fun targetGroups(argument: suspend ListenerRuleActionForwardTargetGroupArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ListenerRuleActionForwardTargetGroupArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.targetGroups = mapped
    }

    /**
     * @param values The target groups. Traffic matching the rule is forwarded to the specified target groups. With forward actions, you can assign a weight that controls the prioritization and selection of each target group. This means that requests are distributed to individual target groups based on their weights. For example, if two target groups have the same weight, each target group receives half of the traffic.
     * The default value is 1 with maximum number of 2. If only one target group is provided, there is no need to set the weight; 100% of traffic will go to that target group.
     */
    @JvmName("ivhaqppgbgpsvojd")
    public suspend fun targetGroups(vararg values: ListenerRuleActionForwardTargetGroupArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetGroups = mapped
    }

    internal fun build(): ListenerRuleActionForwardArgs = ListenerRuleActionForwardArgs(
        targetGroups = targetGroups ?: throw PulumiNullFieldException("targetGroups"),
    )
}
