@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.vpclattice.kotlin.inputs

import com.pulumi.aws.vpclattice.inputs.ListenerRuleActionForwardTargetGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property targetGroupIdentifier
 * @property weight
 */
public data class ListenerRuleActionForwardTargetGroupArgs(
    public val targetGroupIdentifier: Output<String>,
    public val weight: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.vpclattice.inputs.ListenerRuleActionForwardTargetGroupArgs> {
    override fun toJava(): com.pulumi.aws.vpclattice.inputs.ListenerRuleActionForwardTargetGroupArgs =
        com.pulumi.aws.vpclattice.inputs.ListenerRuleActionForwardTargetGroupArgs.builder()
            .targetGroupIdentifier(targetGroupIdentifier.applyValue({ args0 -> args0 }))
            .weight(weight?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ListenerRuleActionForwardTargetGroupArgs].
 */
@PulumiTagMarker
public class ListenerRuleActionForwardTargetGroupArgsBuilder internal constructor() {
    private var targetGroupIdentifier: Output<String>? = null

    private var weight: Output<Int>? = null

    /**
     * @param value
     */
    @JvmName("ywdjnfgjtlcnnakk")
    public suspend fun targetGroupIdentifier(`value`: Output<String>) {
        this.targetGroupIdentifier = value
    }

    /**
     * @param value
     */
    @JvmName("dxolrwpdvweqobqb")
    public suspend fun weight(`value`: Output<Int>) {
        this.weight = value
    }

    /**
     * @param value
     */
    @JvmName("rhdbufnmnsemelyv")
    public suspend fun targetGroupIdentifier(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetGroupIdentifier = mapped
    }

    /**
     * @param value
     */
    @JvmName("vlytkuamfhjemdhk")
    public suspend fun weight(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weight = mapped
    }

    internal fun build(): ListenerRuleActionForwardTargetGroupArgs =
        ListenerRuleActionForwardTargetGroupArgs(
            targetGroupIdentifier = targetGroupIdentifier ?: throw
                PulumiNullFieldException("targetGroupIdentifier"),
            weight = weight,
        )
}
