@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.vpclattice.kotlin.inputs

import com.pulumi.aws.vpclattice.inputs.ListenerRuleMatchHttpMatchHeaderMatchMatchArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property contains Specifies a contains type match.
 * @property exact Specifies an exact type match.
 * @property prefix Specifies a prefix type match. Matches the value with the prefix.
 */
public data class ListenerRuleMatchHttpMatchHeaderMatchMatchArgs(
    public val contains: Output<String>? = null,
    public val exact: Output<String>? = null,
    public val prefix: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.vpclattice.inputs.ListenerRuleMatchHttpMatchHeaderMatchMatchArgs> {
    override fun toJava():
        com.pulumi.aws.vpclattice.inputs.ListenerRuleMatchHttpMatchHeaderMatchMatchArgs =
        com.pulumi.aws.vpclattice.inputs.ListenerRuleMatchHttpMatchHeaderMatchMatchArgs.builder()
            .contains(contains?.applyValue({ args0 -> args0 }))
            .exact(exact?.applyValue({ args0 -> args0 }))
            .prefix(prefix?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ListenerRuleMatchHttpMatchHeaderMatchMatchArgs].
 */
@PulumiTagMarker
public class ListenerRuleMatchHttpMatchHeaderMatchMatchArgsBuilder internal constructor() {
    private var contains: Output<String>? = null

    private var exact: Output<String>? = null

    private var prefix: Output<String>? = null

    /**
     * @param value Specifies a contains type match.
     */
    @JvmName("isnotfetnynykqdq")
    public suspend fun contains(`value`: Output<String>) {
        this.contains = value
    }

    /**
     * @param value Specifies an exact type match.
     */
    @JvmName("fpkghbkigwqfhnpg")
    public suspend fun exact(`value`: Output<String>) {
        this.exact = value
    }

    /**
     * @param value Specifies a prefix type match. Matches the value with the prefix.
     */
    @JvmName("kgkasvncfpkuvaoa")
    public suspend fun prefix(`value`: Output<String>) {
        this.prefix = value
    }

    /**
     * @param value Specifies a contains type match.
     */
    @JvmName("wxmvtmuuscnjnvap")
    public suspend fun contains(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contains = mapped
    }

    /**
     * @param value Specifies an exact type match.
     */
    @JvmName("njehbdnpslnpubrn")
    public suspend fun exact(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exact = mapped
    }

    /**
     * @param value Specifies a prefix type match. Matches the value with the prefix.
     */
    @JvmName("tgwkbtudeaiqmeku")
    public suspend fun prefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefix = mapped
    }

    internal fun build(): ListenerRuleMatchHttpMatchHeaderMatchMatchArgs =
        ListenerRuleMatchHttpMatchHeaderMatchMatchArgs(
            contains = contains,
            exact = exact,
            prefix = prefix,
        )
}
