@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.vpclattice.kotlin.inputs

import com.pulumi.aws.vpclattice.inputs.TargetGroupConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property healthCheck The health check configuration.
 * @property ipAddressType The type of IP address used for the target group. Valid values: `IPV4` | `IPV6`.
 * @property lambdaEventStructureVersion The version of the event structure that the Lambda function receives. Supported only if `type` is `LAMBDA`. Valid Values are `V1` | `V2`.
 * @property port The port on which the targets are listening.
 * @property protocol The protocol to use for routing traffic to the targets. Valid Values are `HTTP` | `HTTPS`.
 * @property protocolVersion The protocol version. Valid Values are `HTTP1` | `HTTP2` | `GRPC`. Default value is `HTTP1`.
 * @property vpcIdentifier The ID of the VPC.
 */
public data class TargetGroupConfigArgs(
    public val healthCheck: Output<TargetGroupConfigHealthCheckArgs>? = null,
    public val ipAddressType: Output<String>? = null,
    public val lambdaEventStructureVersion: Output<String>? = null,
    public val port: Output<Int>? = null,
    public val protocol: Output<String>? = null,
    public val protocolVersion: Output<String>? = null,
    public val vpcIdentifier: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.vpclattice.inputs.TargetGroupConfigArgs> {
    override fun toJava(): com.pulumi.aws.vpclattice.inputs.TargetGroupConfigArgs =
        com.pulumi.aws.vpclattice.inputs.TargetGroupConfigArgs.builder()
            .healthCheck(healthCheck?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .ipAddressType(ipAddressType?.applyValue({ args0 -> args0 }))
            .lambdaEventStructureVersion(lambdaEventStructureVersion?.applyValue({ args0 -> args0 }))
            .port(port?.applyValue({ args0 -> args0 }))
            .protocol(protocol?.applyValue({ args0 -> args0 }))
            .protocolVersion(protocolVersion?.applyValue({ args0 -> args0 }))
            .vpcIdentifier(vpcIdentifier?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TargetGroupConfigArgs].
 */
@PulumiTagMarker
public class TargetGroupConfigArgsBuilder internal constructor() {
    private var healthCheck: Output<TargetGroupConfigHealthCheckArgs>? = null

    private var ipAddressType: Output<String>? = null

    private var lambdaEventStructureVersion: Output<String>? = null

    private var port: Output<Int>? = null

    private var protocol: Output<String>? = null

    private var protocolVersion: Output<String>? = null

    private var vpcIdentifier: Output<String>? = null

    /**
     * @param value The health check configuration.
     */
    @JvmName("vyncblycgksehifw")
    public suspend fun healthCheck(`value`: Output<TargetGroupConfigHealthCheckArgs>) {
        this.healthCheck = value
    }

    /**
     * @param value The type of IP address used for the target group. Valid values: `IPV4` | `IPV6`.
     */
    @JvmName("virdunoqyywqnvlo")
    public suspend fun ipAddressType(`value`: Output<String>) {
        this.ipAddressType = value
    }

    /**
     * @param value The version of the event structure that the Lambda function receives. Supported only if `type` is `LAMBDA`. Valid Values are `V1` | `V2`.
     */
    @JvmName("lajsrvxbravghijw")
    public suspend fun lambdaEventStructureVersion(`value`: Output<String>) {
        this.lambdaEventStructureVersion = value
    }

    /**
     * @param value The port on which the targets are listening.
     */
    @JvmName("ecddobfcnteqsrdw")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value The protocol to use for routing traffic to the targets. Valid Values are `HTTP` | `HTTPS`.
     */
    @JvmName("lbedceuotmmdffqd")
    public suspend fun protocol(`value`: Output<String>) {
        this.protocol = value
    }

    /**
     * @param value The protocol version. Valid Values are `HTTP1` | `HTTP2` | `GRPC`. Default value is `HTTP1`.
     */
    @JvmName("ygmodvkqfhsqgctl")
    public suspend fun protocolVersion(`value`: Output<String>) {
        this.protocolVersion = value
    }

    /**
     * @param value The ID of the VPC.
     */
    @JvmName("wuwgxxvnegaaiapc")
    public suspend fun vpcIdentifier(`value`: Output<String>) {
        this.vpcIdentifier = value
    }

    /**
     * @param value The health check configuration.
     */
    @JvmName("fqjrijvkdrrcfhtp")
    public suspend fun healthCheck(`value`: TargetGroupConfigHealthCheckArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheck = mapped
    }

    /**
     * @param argument The health check configuration.
     */
    @JvmName("rhvyhdycvdygfwfa")
    public suspend
    fun healthCheck(argument: suspend TargetGroupConfigHealthCheckArgsBuilder.() -> Unit) {
        val toBeMapped = TargetGroupConfigHealthCheckArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.healthCheck = mapped
    }

    /**
     * @param value The type of IP address used for the target group. Valid values: `IPV4` | `IPV6`.
     */
    @JvmName("yhqkvmijemdxnhnh")
    public suspend fun ipAddressType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipAddressType = mapped
    }

    /**
     * @param value The version of the event structure that the Lambda function receives. Supported only if `type` is `LAMBDA`. Valid Values are `V1` | `V2`.
     */
    @JvmName("xovljrsclyvblefd")
    public suspend fun lambdaEventStructureVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lambdaEventStructureVersion = mapped
    }

    /**
     * @param value The port on which the targets are listening.
     */
    @JvmName("wcmmwfvnuhyjipus")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value The protocol to use for routing traffic to the targets. Valid Values are `HTTP` | `HTTPS`.
     */
    @JvmName("egnvtksjniliwchv")
    public suspend fun protocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value The protocol version. Valid Values are `HTTP1` | `HTTP2` | `GRPC`. Default value is `HTTP1`.
     */
    @JvmName("wmtyifubnhhrorcd")
    public suspend fun protocolVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocolVersion = mapped
    }

    /**
     * @param value The ID of the VPC.
     */
    @JvmName("wjokvqfjlhhgnhrp")
    public suspend fun vpcIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcIdentifier = mapped
    }

    internal fun build(): TargetGroupConfigArgs = TargetGroupConfigArgs(
        healthCheck = healthCheck,
        ipAddressType = ipAddressType,
        lambdaEventStructureVersion = lambdaEventStructureVersion,
        port = port,
        protocol = protocol,
        protocolVersion = protocolVersion,
        vpcIdentifier = vpcIdentifier,
    )
}
