@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.vpclattice.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getListener.
 * @property arn ARN of the listener.
 * @property createdAt The date and time that the listener was created.
 * @property defaultActions The actions for the default listener rule.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property lastUpdatedAt The date and time the listener was last updated.
 * @property listenerId The ID of the listener.
 * @property listenerIdentifier
 * @property name The name of the listener.
 * @property port The listener port.
 * @property protocol The listener protocol. Either `HTTPS` or `HTTP`.
 * @property serviceArn The ARN of the service.
 * @property serviceId The ID of the service.
 * @property serviceIdentifier
 * @property tags List of tags associated with the listener.
 */
public data class GetListenerResult(
    public val arn: String,
    public val createdAt: String,
    public val defaultActions: List<GetListenerDefaultAction>,
    public val id: String,
    public val lastUpdatedAt: String,
    public val listenerId: String,
    public val listenerIdentifier: String,
    public val name: String,
    public val port: Int,
    public val protocol: String,
    public val serviceArn: String,
    public val serviceId: String,
    public val serviceIdentifier: String,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.vpclattice.outputs.GetListenerResult):
            GetListenerResult = GetListenerResult(
            arn = javaType.arn(),
            createdAt = javaType.createdAt(),
            defaultActions = javaType.defaultActions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.vpclattice.kotlin.outputs.GetListenerDefaultAction.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            lastUpdatedAt = javaType.lastUpdatedAt(),
            listenerId = javaType.listenerId(),
            listenerIdentifier = javaType.listenerIdentifier(),
            name = javaType.name(),
            port = javaType.port(),
            protocol = javaType.protocol(),
            serviceArn = javaType.serviceArn(),
            serviceId = javaType.serviceId(),
            serviceIdentifier = javaType.serviceIdentifier(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
