@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.vpclattice.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A collection of values returned by getServiceNetwork.
 * @property arn ARN of the Service Network.
 * @property authType Authentication type for the service network. Either `NONE` or `AWS_IAM`.
 * @property createdAt Date and time the service network was created.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property lastUpdatedAt Date and time the service network was last updated.
 * @property name Name of the service network.
 * @property numberOfAssociatedServices Number of services associated with this service network.
 * @property numberOfAssociatedVpcs Number of VPCs associated with this service network.
 * @property serviceNetworkIdentifier
 * @property tags
 */
public data class GetServiceNetworkResult(
    public val arn: String,
    public val authType: String,
    public val createdAt: String,
    public val id: String,
    public val lastUpdatedAt: String,
    public val name: String,
    public val numberOfAssociatedServices: Int,
    public val numberOfAssociatedVpcs: Int,
    public val serviceNetworkIdentifier: String,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.vpclattice.outputs.GetServiceNetworkResult):
            GetServiceNetworkResult = GetServiceNetworkResult(
            arn = javaType.arn(),
            authType = javaType.authType(),
            createdAt = javaType.createdAt(),
            id = javaType.id(),
            lastUpdatedAt = javaType.lastUpdatedAt(),
            name = javaType.name(),
            numberOfAssociatedServices = javaType.numberOfAssociatedServices(),
            numberOfAssociatedVpcs = javaType.numberOfAssociatedVpcs(),
            serviceNetworkIdentifier = javaType.serviceNetworkIdentifier(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
