@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.vpclattice.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property targetGroupIdentifier ID or Amazon Resource Name (ARN) of the target group.
 * @property weight Determines how requests are distributed to the target group. Only required if you specify multiple target groups for a forward action. For example, if you specify two target groups, one with a
 * weight of 10 and the other with a weight of 20, the target group with a weight of 20 receives twice as many requests as the other target group. See [Listener rules](https://docs.aws.amazon.com/vpc-lattice/latest/ug/listeners.html#listener-rules) in the AWS documentation for additional examples. Default: `100`.
 */
public data class ListenerDefaultActionForwardTargetGroup(
    public val targetGroupIdentifier: String? = null,
    public val weight: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.vpclattice.outputs.ListenerDefaultActionForwardTargetGroup):
            ListenerDefaultActionForwardTargetGroup = ListenerDefaultActionForwardTargetGroup(
            targetGroupIdentifier = javaType.targetGroupIdentifier().map({ args0 -> args0 }).orElse(null),
            weight = javaType.weight().map({ args0 -> args0 }).orElse(null),
        )
    }
}
