@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.vpclattice.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property id The ID of the target. If the target type of the target group is INSTANCE, this is an instance ID. If the target type is IP , this is an IP address. If the target type is LAMBDA, this is the ARN of the Lambda function. If the target type is ALB, this is the ARN of the Application Load Balancer.
 * @property port This port is used for routing traffic to the target, and defaults to the target group port. However, you can override the default and specify a custom port.
 */
public data class TargetGroupAttachmentTarget(
    public val id: String,
    public val port: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.vpclattice.outputs.TargetGroupAttachmentTarget):
            TargetGroupAttachmentTarget = TargetGroupAttachmentTarget(
            id = javaType.id(),
            port = javaType.port().map({ args0 -> args0 }).orElse(null),
        )
    }
}
