@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.waf.kotlin

import com.pulumi.aws.waf.kotlin.outputs.ByteMatchSetByteMatchTuple
import com.pulumi.aws.waf.kotlin.outputs.ByteMatchSetByteMatchTuple.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [ByteMatchSet].
 */
@PulumiTagMarker
public class ByteMatchSetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ByteMatchSetArgs = ByteMatchSetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ByteMatchSetArgsBuilder.() -> Unit) {
        val builder = ByteMatchSetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ByteMatchSet {
        val builtJavaResource = com.pulumi.aws.waf.ByteMatchSet(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ByteMatchSet(builtJavaResource)
    }
}

/**
 * Provides a WAF Byte Match Set Resource
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.waf.ByteMatchSet;
 * import com.pulumi.aws.waf.ByteMatchSetArgs;
 * import com.pulumi.aws.waf.inputs.ByteMatchSetByteMatchTupleArgs;
 * import com.pulumi.aws.waf.inputs.ByteMatchSetByteMatchTupleFieldToMatchArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var byteSet = new ByteMatchSet("byteSet", ByteMatchSetArgs.builder()
 *             .byteMatchTuples(ByteMatchSetByteMatchTupleArgs.builder()
 *                 .fieldToMatch(ByteMatchSetByteMatchTupleFieldToMatchArgs.builder()
 *                     .data("referer")
 *                     .type("HEADER")
 *                     .build())
 *                 .positionalConstraint("CONTAINS")
 *                 .targetString("badrefer1")
 *                 .textTransformation("NONE")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import WAF Byte Match Set using the id. For example:
 * ```sh
 *  $ pulumi import aws:waf/byteMatchSet:ByteMatchSet byte_set a1b2c3d4-d5f6-7777-8888-9999aaaabbbbcccc
 * ```
 *
 */
public class ByteMatchSet internal constructor(
    override val javaResource: com.pulumi.aws.waf.ByteMatchSet,
) : KotlinCustomResource(javaResource, ByteMatchSetMapper) {
    /**
     * Specifies the bytes (typically a string that corresponds
     * with ASCII characters) that you want to search for in web requests,
     * the location in requests that you want to search, and other settings.
     */
    public val byteMatchTuples: Output<List<ByteMatchSetByteMatchTuple>>?
        get() = javaResource.byteMatchTuples().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })
            }).orElse(null)
        })

    /**
     * The name or description of the Byte Match Set.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })
}

public object ByteMatchSetMapper : ResourceMapper<ByteMatchSet> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.waf.ByteMatchSet::class == javaResource::class

    override fun map(javaResource: Resource): ByteMatchSet = ByteMatchSet(
        javaResource as
            com.pulumi.aws.waf.ByteMatchSet,
    )
}

/**
 * @see [ByteMatchSet].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ByteMatchSet].
 */
public suspend fun byteMatchSet(
    name: String,
    block: suspend ByteMatchSetResourceBuilder.() -> Unit,
): ByteMatchSet {
    val builder = ByteMatchSetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ByteMatchSet].
 * @param name The _unique_ name of the resulting resource.
 */
public fun byteMatchSet(name: String): ByteMatchSet {
    val builder = ByteMatchSetResourceBuilder()
    builder.name(name)
    return builder.build()
}
