@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.waf.kotlin

import com.pulumi.aws.waf.ByteMatchSetArgs.builder
import com.pulumi.aws.waf.kotlin.inputs.ByteMatchSetByteMatchTupleArgs
import com.pulumi.aws.waf.kotlin.inputs.ByteMatchSetByteMatchTupleArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a WAF Byte Match Set Resource
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.waf.ByteMatchSet;
 * import com.pulumi.aws.waf.ByteMatchSetArgs;
 * import com.pulumi.aws.waf.inputs.ByteMatchSetByteMatchTupleArgs;
 * import com.pulumi.aws.waf.inputs.ByteMatchSetByteMatchTupleFieldToMatchArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var byteSet = new ByteMatchSet("byteSet", ByteMatchSetArgs.builder()
 *             .byteMatchTuples(ByteMatchSetByteMatchTupleArgs.builder()
 *                 .fieldToMatch(ByteMatchSetByteMatchTupleFieldToMatchArgs.builder()
 *                     .data("referer")
 *                     .type("HEADER")
 *                     .build())
 *                 .positionalConstraint("CONTAINS")
 *                 .targetString("badrefer1")
 *                 .textTransformation("NONE")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import WAF Byte Match Set using the id. For example:
 * ```sh
 *  $ pulumi import aws:waf/byteMatchSet:ByteMatchSet byte_set a1b2c3d4-d5f6-7777-8888-9999aaaabbbbcccc
 * ```
 * @property byteMatchTuples Specifies the bytes (typically a string that corresponds
 * with ASCII characters) that you want to search for in web requests,
 * the location in requests that you want to search, and other settings.
 * @property name The name or description of the Byte Match Set.
 */
public data class ByteMatchSetArgs(
    public val byteMatchTuples: Output<List<ByteMatchSetByteMatchTupleArgs>>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.waf.ByteMatchSetArgs> {
    override fun toJava(): com.pulumi.aws.waf.ByteMatchSetArgs =
        com.pulumi.aws.waf.ByteMatchSetArgs.builder()
            .byteMatchTuples(
                byteMatchTuples?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ByteMatchSetArgs].
 */
@PulumiTagMarker
public class ByteMatchSetArgsBuilder internal constructor() {
    private var byteMatchTuples: Output<List<ByteMatchSetByteMatchTupleArgs>>? = null

    private var name: Output<String>? = null

    /**
     * @param value Specifies the bytes (typically a string that corresponds
     * with ASCII characters) that you want to search for in web requests,
     * the location in requests that you want to search, and other settings.
     */
    @JvmName("ydgmgpcsrfrolvqu")
    public suspend fun byteMatchTuples(`value`: Output<List<ByteMatchSetByteMatchTupleArgs>>) {
        this.byteMatchTuples = value
    }

    @JvmName("okqjjhbcvcibarck")
    public suspend fun byteMatchTuples(vararg values: Output<ByteMatchSetByteMatchTupleArgs>) {
        this.byteMatchTuples = Output.all(values.asList())
    }

    /**
     * @param values Specifies the bytes (typically a string that corresponds
     * with ASCII characters) that you want to search for in web requests,
     * the location in requests that you want to search, and other settings.
     */
    @JvmName("chpagfpphqhfholq")
    public suspend fun byteMatchTuples(values: List<Output<ByteMatchSetByteMatchTupleArgs>>) {
        this.byteMatchTuples = Output.all(values)
    }

    /**
     * @param value The name or description of the Byte Match Set.
     */
    @JvmName("tiutkhesditjlnko")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Specifies the bytes (typically a string that corresponds
     * with ASCII characters) that you want to search for in web requests,
     * the location in requests that you want to search, and other settings.
     */
    @JvmName("mdalwkdswmcfyhvc")
    public suspend fun byteMatchTuples(`value`: List<ByteMatchSetByteMatchTupleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.byteMatchTuples = mapped
    }

    /**
     * @param argument Specifies the bytes (typically a string that corresponds
     * with ASCII characters) that you want to search for in web requests,
     * the location in requests that you want to search, and other settings.
     */
    @JvmName("ehuxyhsrcvlsehas")
    public suspend
    fun byteMatchTuples(argument: List<suspend ByteMatchSetByteMatchTupleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ByteMatchSetByteMatchTupleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.byteMatchTuples = mapped
    }

    /**
     * @param argument Specifies the bytes (typically a string that corresponds
     * with ASCII characters) that you want to search for in web requests,
     * the location in requests that you want to search, and other settings.
     */
    @JvmName("vrpfxnvaqphuismm")
    public suspend fun byteMatchTuples(
        vararg
        argument: suspend ByteMatchSetByteMatchTupleArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ByteMatchSetByteMatchTupleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.byteMatchTuples = mapped
    }

    /**
     * @param argument Specifies the bytes (typically a string that corresponds
     * with ASCII characters) that you want to search for in web requests,
     * the location in requests that you want to search, and other settings.
     */
    @JvmName("auqgdnyxlyqlfqop")
    public suspend
    fun byteMatchTuples(argument: suspend ByteMatchSetByteMatchTupleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ByteMatchSetByteMatchTupleArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.byteMatchTuples = mapped
    }

    /**
     * @param values Specifies the bytes (typically a string that corresponds
     * with ASCII characters) that you want to search for in web requests,
     * the location in requests that you want to search, and other settings.
     */
    @JvmName("hhcrrrvbtrarqlba")
    public suspend fun byteMatchTuples(vararg values: ByteMatchSetByteMatchTupleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.byteMatchTuples = mapped
    }

    /**
     * @param value The name or description of the Byte Match Set.
     */
    @JvmName("jirciftjjmqtweil")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): ByteMatchSetArgs = ByteMatchSetArgs(
        byteMatchTuples = byteMatchTuples,
        name = name,
    )
}
