@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.waf.kotlin

import com.pulumi.aws.waf.RegexMatchSetArgs.builder
import com.pulumi.aws.waf.kotlin.inputs.RegexMatchSetRegexMatchTupleArgs
import com.pulumi.aws.waf.kotlin.inputs.RegexMatchSetRegexMatchTupleArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a WAF Regex Match Set Resource
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.waf.RegexPatternSet;
 * import com.pulumi.aws.waf.RegexPatternSetArgs;
 * import com.pulumi.aws.waf.RegexMatchSet;
 * import com.pulumi.aws.waf.RegexMatchSetArgs;
 * import com.pulumi.aws.waf.inputs.RegexMatchSetRegexMatchTupleArgs;
 * import com.pulumi.aws.waf.inputs.RegexMatchSetRegexMatchTupleFieldToMatchArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleRegexPatternSet = new RegexPatternSet("exampleRegexPatternSet", RegexPatternSetArgs.builder()
 *             .regexPatternStrings(
 *                 "one",
 *                 "two")
 *             .build());
 *         var exampleRegexMatchSet = new RegexMatchSet("exampleRegexMatchSet", RegexMatchSetArgs.builder()
 *             .regexMatchTuples(RegexMatchSetRegexMatchTupleArgs.builder()
 *                 .fieldToMatch(RegexMatchSetRegexMatchTupleFieldToMatchArgs.builder()
 *                     .data("User-Agent")
 *                     .type("HEADER")
 *                     .build())
 *                 .regexPatternSetId(exampleRegexPatternSet.id())
 *                 .textTransformation("NONE")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import WAF Regex Match Set using their ID. For example:
 * ```sh
 *  $ pulumi import aws:waf/regexMatchSet:RegexMatchSet example a1b2c3d4-d5f6-7777-8888-9999aaaabbbbcccc
 * ```
 * @property name The name or description of the Regex Match Set.
 * @property regexMatchTuples The regular expression pattern that you want AWS WAF to search for in web requests, the location in requests that you want AWS WAF to search, and other settings. See below.
 */
public data class RegexMatchSetArgs(
    public val name: Output<String>? = null,
    public val regexMatchTuples: Output<List<RegexMatchSetRegexMatchTupleArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.waf.RegexMatchSetArgs> {
    override fun toJava(): com.pulumi.aws.waf.RegexMatchSetArgs =
        com.pulumi.aws.waf.RegexMatchSetArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .regexMatchTuples(
                regexMatchTuples?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [RegexMatchSetArgs].
 */
@PulumiTagMarker
public class RegexMatchSetArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var regexMatchTuples: Output<List<RegexMatchSetRegexMatchTupleArgs>>? = null

    /**
     * @param value The name or description of the Regex Match Set.
     */
    @JvmName("gholjtaixtyainhd")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The regular expression pattern that you want AWS WAF to search for in web requests, the location in requests that you want AWS WAF to search, and other settings. See below.
     */
    @JvmName("cmkamrrhhchtwrkw")
    public suspend fun regexMatchTuples(`value`: Output<List<RegexMatchSetRegexMatchTupleArgs>>) {
        this.regexMatchTuples = value
    }

    @JvmName("ysofrxypwbevedje")
    public suspend fun regexMatchTuples(vararg values: Output<RegexMatchSetRegexMatchTupleArgs>) {
        this.regexMatchTuples = Output.all(values.asList())
    }

    /**
     * @param values The regular expression pattern that you want AWS WAF to search for in web requests, the location in requests that you want AWS WAF to search, and other settings. See below.
     */
    @JvmName("glybugbanxudcrdr")
    public suspend fun regexMatchTuples(values: List<Output<RegexMatchSetRegexMatchTupleArgs>>) {
        this.regexMatchTuples = Output.all(values)
    }

    /**
     * @param value The name or description of the Regex Match Set.
     */
    @JvmName("kcwvjchqvsqoqnii")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The regular expression pattern that you want AWS WAF to search for in web requests, the location in requests that you want AWS WAF to search, and other settings. See below.
     */
    @JvmName("hocwidrkipcqfvsn")
    public suspend fun regexMatchTuples(`value`: List<RegexMatchSetRegexMatchTupleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regexMatchTuples = mapped
    }

    /**
     * @param argument The regular expression pattern that you want AWS WAF to search for in web requests, the location in requests that you want AWS WAF to search, and other settings. See below.
     */
    @JvmName("sidoewspvhclhpcd")
    public suspend
    fun regexMatchTuples(argument: List<suspend RegexMatchSetRegexMatchTupleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RegexMatchSetRegexMatchTupleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.regexMatchTuples = mapped
    }

    /**
     * @param argument The regular expression pattern that you want AWS WAF to search for in web requests, the location in requests that you want AWS WAF to search, and other settings. See below.
     */
    @JvmName("bdyousvqqtlqdjfx")
    public suspend fun regexMatchTuples(
        vararg
        argument: suspend RegexMatchSetRegexMatchTupleArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            RegexMatchSetRegexMatchTupleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.regexMatchTuples = mapped
    }

    /**
     * @param argument The regular expression pattern that you want AWS WAF to search for in web requests, the location in requests that you want AWS WAF to search, and other settings. See below.
     */
    @JvmName("joqwutpddijeouql")
    public suspend
    fun regexMatchTuples(argument: suspend RegexMatchSetRegexMatchTupleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            RegexMatchSetRegexMatchTupleArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.regexMatchTuples = mapped
    }

    /**
     * @param values The regular expression pattern that you want AWS WAF to search for in web requests, the location in requests that you want AWS WAF to search, and other settings. See below.
     */
    @JvmName("kouqhqbfhxdjsyhk")
    public suspend fun regexMatchTuples(vararg values: RegexMatchSetRegexMatchTupleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.regexMatchTuples = mapped
    }

    internal fun build(): RegexMatchSetArgs = RegexMatchSetArgs(
        name = name,
        regexMatchTuples = regexMatchTuples,
    )
}
