@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.waf.kotlin

import com.pulumi.aws.waf.RegexPatternSetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a WAF Regex Pattern Set Resource
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.waf.RegexPatternSet;
 * import com.pulumi.aws.waf.RegexPatternSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new RegexPatternSet("example", RegexPatternSetArgs.builder()
 *             .regexPatternStrings(
 *                 "one",
 *                 "two")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import AWS WAF Regex Pattern Set using their ID. For example:
 * ```sh
 *  $ pulumi import aws:waf/regexPatternSet:RegexPatternSet example a1b2c3d4-d5f6-7777-8888-9999aaaabbbbcccc
 * ```
 * @property name The name or description of the Regex Pattern Set.
 * @property regexPatternStrings A list of regular expression (regex) patterns that you want AWS WAF to search for, such as `B[a@]dB[o0]t`.
 */
public data class RegexPatternSetArgs(
    public val name: Output<String>? = null,
    public val regexPatternStrings: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.waf.RegexPatternSetArgs> {
    override fun toJava(): com.pulumi.aws.waf.RegexPatternSetArgs =
        com.pulumi.aws.waf.RegexPatternSetArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .regexPatternStrings(
                regexPatternStrings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [RegexPatternSetArgs].
 */
@PulumiTagMarker
public class RegexPatternSetArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var regexPatternStrings: Output<List<String>>? = null

    /**
     * @param value The name or description of the Regex Pattern Set.
     */
    @JvmName("bpdclbbnogoxgjke")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A list of regular expression (regex) patterns that you want AWS WAF to search for, such as `B[a@]dB[o0]t`.
     */
    @JvmName("kedbtmnhufcnnqqn")
    public suspend fun regexPatternStrings(`value`: Output<List<String>>) {
        this.regexPatternStrings = value
    }

    @JvmName("urepanivlptvmtvi")
    public suspend fun regexPatternStrings(vararg values: Output<String>) {
        this.regexPatternStrings = Output.all(values.asList())
    }

    /**
     * @param values A list of regular expression (regex) patterns that you want AWS WAF to search for, such as `B[a@]dB[o0]t`.
     */
    @JvmName("avcyfkljabnrkkxk")
    public suspend fun regexPatternStrings(values: List<Output<String>>) {
        this.regexPatternStrings = Output.all(values)
    }

    /**
     * @param value The name or description of the Regex Pattern Set.
     */
    @JvmName("eampbgkbsdsrxoho")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A list of regular expression (regex) patterns that you want AWS WAF to search for, such as `B[a@]dB[o0]t`.
     */
    @JvmName("dcwiayaouisplrid")
    public suspend fun regexPatternStrings(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regexPatternStrings = mapped
    }

    /**
     * @param values A list of regular expression (regex) patterns that you want AWS WAF to search for, such as `B[a@]dB[o0]t`.
     */
    @JvmName("tgpqqcatjyytnmvv")
    public suspend fun regexPatternStrings(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.regexPatternStrings = mapped
    }

    internal fun build(): RegexPatternSetArgs = RegexPatternSetArgs(
        name = name,
        regexPatternStrings = regexPatternStrings,
    )
}
