@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.waf.kotlin

import com.pulumi.aws.waf.SqlInjectionMatchSetArgs.builder
import com.pulumi.aws.waf.kotlin.inputs.SqlInjectionMatchSetSqlInjectionMatchTupleArgs
import com.pulumi.aws.waf.kotlin.inputs.SqlInjectionMatchSetSqlInjectionMatchTupleArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a WAF SQL Injection Match Set Resource
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.waf.SqlInjectionMatchSet;
 * import com.pulumi.aws.waf.SqlInjectionMatchSetArgs;
 * import com.pulumi.aws.waf.inputs.SqlInjectionMatchSetSqlInjectionMatchTupleArgs;
 * import com.pulumi.aws.waf.inputs.SqlInjectionMatchSetSqlInjectionMatchTupleFieldToMatchArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlInjectionMatchSet = new SqlInjectionMatchSet("sqlInjectionMatchSet", SqlInjectionMatchSetArgs.builder()
 *             .sqlInjectionMatchTuples(SqlInjectionMatchSetSqlInjectionMatchTupleArgs.builder()
 *                 .fieldToMatch(SqlInjectionMatchSetSqlInjectionMatchTupleFieldToMatchArgs.builder()
 *                     .type("QUERY_STRING")
 *                     .build())
 *                 .textTransformation("URL_DECODE")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import AWS WAF SQL Injection Match Set using their ID. For example:
 * ```sh
 *  $ pulumi import aws:waf/sqlInjectionMatchSet:SqlInjectionMatchSet example a1b2c3d4-d5f6-7777-8888-9999aaaabbbbcccc
 * ```
 * @property name The name or description of the SQL Injection Match Set.
 * @property sqlInjectionMatchTuples The parts of web requests that you want AWS WAF to inspect for malicious SQL code and, if you want AWS WAF to inspect a header, the name of the header.
 */
public data class SqlInjectionMatchSetArgs(
    public val name: Output<String>? = null,
    public val sqlInjectionMatchTuples: Output<List<SqlInjectionMatchSetSqlInjectionMatchTupleArgs>>? =
        null,
) : ConvertibleToJava<com.pulumi.aws.waf.SqlInjectionMatchSetArgs> {
    override fun toJava(): com.pulumi.aws.waf.SqlInjectionMatchSetArgs =
        com.pulumi.aws.waf.SqlInjectionMatchSetArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .sqlInjectionMatchTuples(
                sqlInjectionMatchTuples?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [SqlInjectionMatchSetArgs].
 */
@PulumiTagMarker
public class SqlInjectionMatchSetArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var sqlInjectionMatchTuples: Output<List<SqlInjectionMatchSetSqlInjectionMatchTupleArgs>>? =
        null

    /**
     * @param value The name or description of the SQL Injection Match Set.
     */
    @JvmName("mencmydxitnecesn")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The parts of web requests that you want AWS WAF to inspect for malicious SQL code and, if you want AWS WAF to inspect a header, the name of the header.
     */
    @JvmName("pommfowtfhqkodul")
    public suspend
    fun sqlInjectionMatchTuples(`value`: Output<List<SqlInjectionMatchSetSqlInjectionMatchTupleArgs>>) {
        this.sqlInjectionMatchTuples = value
    }

    @JvmName("jqlplcpkwtxoqxhs")
    public suspend fun sqlInjectionMatchTuples(
        vararg
        values: Output<SqlInjectionMatchSetSqlInjectionMatchTupleArgs>,
    ) {
        this.sqlInjectionMatchTuples = Output.all(values.asList())
    }

    /**
     * @param values The parts of web requests that you want AWS WAF to inspect for malicious SQL code and, if you want AWS WAF to inspect a header, the name of the header.
     */
    @JvmName("pabnqjmgndappasy")
    public suspend
    fun sqlInjectionMatchTuples(values: List<Output<SqlInjectionMatchSetSqlInjectionMatchTupleArgs>>) {
        this.sqlInjectionMatchTuples = Output.all(values)
    }

    /**
     * @param value The name or description of the SQL Injection Match Set.
     */
    @JvmName("isksecuphjhvnnoc")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The parts of web requests that you want AWS WAF to inspect for malicious SQL code and, if you want AWS WAF to inspect a header, the name of the header.
     */
    @JvmName("kvilxtjeoshyufca")
    public suspend
    fun sqlInjectionMatchTuples(`value`: List<SqlInjectionMatchSetSqlInjectionMatchTupleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqlInjectionMatchTuples = mapped
    }

    /**
     * @param argument The parts of web requests that you want AWS WAF to inspect for malicious SQL code and, if you want AWS WAF to inspect a header, the name of the header.
     */
    @JvmName("crskksjcsmvvtmks")
    public suspend
    fun sqlInjectionMatchTuples(argument: List<suspend SqlInjectionMatchSetSqlInjectionMatchTupleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SqlInjectionMatchSetSqlInjectionMatchTupleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.sqlInjectionMatchTuples = mapped
    }

    /**
     * @param argument The parts of web requests that you want AWS WAF to inspect for malicious SQL code and, if you want AWS WAF to inspect a header, the name of the header.
     */
    @JvmName("icpayochnlsbgedm")
    public suspend fun sqlInjectionMatchTuples(
        vararg
        argument: suspend SqlInjectionMatchSetSqlInjectionMatchTupleArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            SqlInjectionMatchSetSqlInjectionMatchTupleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.sqlInjectionMatchTuples = mapped
    }

    /**
     * @param argument The parts of web requests that you want AWS WAF to inspect for malicious SQL code and, if you want AWS WAF to inspect a header, the name of the header.
     */
    @JvmName("qxmbdthbmmqioyhm")
    public suspend
    fun sqlInjectionMatchTuples(argument: suspend SqlInjectionMatchSetSqlInjectionMatchTupleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            SqlInjectionMatchSetSqlInjectionMatchTupleArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.sqlInjectionMatchTuples = mapped
    }

    /**
     * @param values The parts of web requests that you want AWS WAF to inspect for malicious SQL code and, if you want AWS WAF to inspect a header, the name of the header.
     */
    @JvmName("mvtydudhlhvmjajn")
    public suspend fun sqlInjectionMatchTuples(
        vararg
        values: SqlInjectionMatchSetSqlInjectionMatchTupleArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sqlInjectionMatchTuples = mapped
    }

    internal fun build(): SqlInjectionMatchSetArgs = SqlInjectionMatchSetArgs(
        name = name,
        sqlInjectionMatchTuples = sqlInjectionMatchTuples,
    )
}
