@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.waf.kotlin

import com.pulumi.aws.waf.WafFunctions.getIpsetPlain
import com.pulumi.aws.waf.WafFunctions.getRateBasedRulePlain
import com.pulumi.aws.waf.WafFunctions.getRulePlain
import com.pulumi.aws.waf.WafFunctions.getSubscribedRuleGroupPlain
import com.pulumi.aws.waf.WafFunctions.getWebAclPlain
import com.pulumi.aws.waf.kotlin.inputs.GetIpsetPlainArgs
import com.pulumi.aws.waf.kotlin.inputs.GetIpsetPlainArgsBuilder
import com.pulumi.aws.waf.kotlin.inputs.GetRateBasedRulePlainArgs
import com.pulumi.aws.waf.kotlin.inputs.GetRateBasedRulePlainArgsBuilder
import com.pulumi.aws.waf.kotlin.inputs.GetRulePlainArgs
import com.pulumi.aws.waf.kotlin.inputs.GetRulePlainArgsBuilder
import com.pulumi.aws.waf.kotlin.inputs.GetSubscribedRuleGroupPlainArgs
import com.pulumi.aws.waf.kotlin.inputs.GetSubscribedRuleGroupPlainArgsBuilder
import com.pulumi.aws.waf.kotlin.inputs.GetWebAclPlainArgs
import com.pulumi.aws.waf.kotlin.inputs.GetWebAclPlainArgsBuilder
import com.pulumi.aws.waf.kotlin.outputs.GetIpsetResult
import com.pulumi.aws.waf.kotlin.outputs.GetRateBasedRuleResult
import com.pulumi.aws.waf.kotlin.outputs.GetRuleResult
import com.pulumi.aws.waf.kotlin.outputs.GetSubscribedRuleGroupResult
import com.pulumi.aws.waf.kotlin.outputs.GetWebAclResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.aws.waf.kotlin.outputs.GetIpsetResult.Companion.toKotlin as getIpsetResultToKotlin
import com.pulumi.aws.waf.kotlin.outputs.GetRateBasedRuleResult.Companion.toKotlin as getRateBasedRuleResultToKotlin
import com.pulumi.aws.waf.kotlin.outputs.GetRuleResult.Companion.toKotlin as getRuleResultToKotlin
import com.pulumi.aws.waf.kotlin.outputs.GetSubscribedRuleGroupResult.Companion.toKotlin as getSubscribedRuleGroupResultToKotlin
import com.pulumi.aws.waf.kotlin.outputs.GetWebAclResult.Companion.toKotlin as getWebAclResultToKotlin

public object WafFunctions {
    /**
     * `aws.waf.IpSet` Retrieves a WAF IP Set Resource Id.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.waf.WafFunctions;
     * import com.pulumi.aws.waf.inputs.GetIpsetArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = WafFunctions.getIpset(GetIpsetArgs.builder()
     *             .name("tfWAFIPSet")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getIpset.
     * @return A collection of values returned by getIpset.
     */
    public suspend fun getIpset(argument: GetIpsetPlainArgs): GetIpsetResult =
        getIpsetResultToKotlin(getIpsetPlain(argument.toJava()).await())

    /**
     * @see [getIpset].
     * @param name Name of the WAF IP set.
     * @return A collection of values returned by getIpset.
     */
    public suspend fun getIpset(name: String): GetIpsetResult {
        val argument = GetIpsetPlainArgs(
            name = name,
        )
        return getIpsetResultToKotlin(getIpsetPlain(argument.toJava()).await())
    }

    /**
     * @see [getIpset].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;waf&#46;kotlin&#46;inputs&#46;GetIpsetPlainArgs].
     * @return A collection of values returned by getIpset.
     */
    public suspend fun getIpset(argument: suspend GetIpsetPlainArgsBuilder.() -> Unit):
        GetIpsetResult {
        val builder = GetIpsetPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getIpsetResultToKotlin(getIpsetPlain(builtArgument.toJava()).await())
    }

    /**
     * `aws.waf.RateBasedRule` Retrieves a WAF Rate Based Rule Resource Id.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.waf.WafFunctions;
     * import com.pulumi.aws.waf.inputs.GetRateBasedRuleArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = WafFunctions.getRateBasedRule(GetRateBasedRuleArgs.builder()
     *             .name("tfWAFRateBasedRule")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getRateBasedRule.
     * @return A collection of values returned by getRateBasedRule.
     */
    public suspend fun getRateBasedRule(argument: GetRateBasedRulePlainArgs): GetRateBasedRuleResult =
        getRateBasedRuleResultToKotlin(getRateBasedRulePlain(argument.toJava()).await())

    /**
     * @see [getRateBasedRule].
     * @param name Name of the WAF rate based rule.
     * @return A collection of values returned by getRateBasedRule.
     */
    public suspend fun getRateBasedRule(name: String): GetRateBasedRuleResult {
        val argument = GetRateBasedRulePlainArgs(
            name = name,
        )
        return getRateBasedRuleResultToKotlin(getRateBasedRulePlain(argument.toJava()).await())
    }

    /**
     * @see [getRateBasedRule].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;waf&#46;kotlin&#46;inputs&#46;GetRateBasedRulePlainArgs].
     * @return A collection of values returned by getRateBasedRule.
     */
    public suspend
    fun getRateBasedRule(argument: suspend GetRateBasedRulePlainArgsBuilder.() -> Unit):
        GetRateBasedRuleResult {
        val builder = GetRateBasedRulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRateBasedRuleResultToKotlin(getRateBasedRulePlain(builtArgument.toJava()).await())
    }

    /**
     * `aws.waf.Rule` Retrieves a WAF Rule Resource Id.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.waf.WafFunctions;
     * import com.pulumi.aws.waf.inputs.GetRuleArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = WafFunctions.getRule(GetRuleArgs.builder()
     *             .name("tfWAFRule")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getRule.
     * @return A collection of values returned by getRule.
     */
    public suspend fun getRule(argument: GetRulePlainArgs): GetRuleResult =
        getRuleResultToKotlin(getRulePlain(argument.toJava()).await())

    /**
     * @see [getRule].
     * @param name Name of the WAF rule.
     * @return A collection of values returned by getRule.
     */
    public suspend fun getRule(name: String): GetRuleResult {
        val argument = GetRulePlainArgs(
            name = name,
        )
        return getRuleResultToKotlin(getRulePlain(argument.toJava()).await())
    }

    /**
     * @see [getRule].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;waf&#46;kotlin&#46;inputs&#46;GetRulePlainArgs].
     * @return A collection of values returned by getRule.
     */
    public suspend fun getRule(argument: suspend GetRulePlainArgsBuilder.() -> Unit): GetRuleResult {
        val builder = GetRulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRuleResultToKotlin(getRulePlain(builtArgument.toJava()).await())
    }

    /**
     * `aws.waf.getSubscribedRuleGroup` retrieves information about a Managed WAF Rule Group from AWS Marketplace (needs to be subscribed to first).
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.waf.WafFunctions;
     * import com.pulumi.aws.waf.inputs.GetSubscribedRuleGroupArgs;
     * import com.pulumi.aws.waf.WebAcl;
     * import com.pulumi.aws.waf.WebAclArgs;
     * import com.pulumi.aws.waf.inputs.WebAclRuleArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var byName = WafFunctions.getSubscribedRuleGroup(GetSubscribedRuleGroupArgs.builder()
     *             .name("F5 Bot Detection Signatures For AWS WAF")
     *             .build());
     *         final var byMetricName = WafFunctions.getSubscribedRuleGroup(GetSubscribedRuleGroupArgs.builder()
     *             .metricName("F5BotDetectionSignatures")
     *             .build());
     *         var acl = new WebAcl("acl", WebAclArgs.builder()
     *             .rules(
     *                 WebAclRuleArgs.builder()
     *                     .priority(1)
     *                     .ruleId(byName.applyValue(getSubscribedRuleGroupResult -> getSubscribedRuleGroupResult.id()))
     *                     .type("GROUP")
     *                     .build(),
     *                 WebAclRuleArgs.builder()
     *                     .priority(2)
     *                     .ruleId(byMetricName.applyValue(getSubscribedRuleGroupResult -> getSubscribedRuleGroupResult.id()))
     *                     .type("GROUP")
     *                     .build())
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getSubscribedRuleGroup.
     * @return A collection of values returned by getSubscribedRuleGroup.
     */
    public suspend fun getSubscribedRuleGroup(argument: GetSubscribedRuleGroupPlainArgs):
        GetSubscribedRuleGroupResult =
        getSubscribedRuleGroupResultToKotlin(getSubscribedRuleGroupPlain(argument.toJava()).await())

    /**
     * @see [getSubscribedRuleGroup].
     * @param metricName Name of the WAF rule group.
     * @param name Name of the WAF rule group.
     * @return A collection of values returned by getSubscribedRuleGroup.
     */
    public suspend fun getSubscribedRuleGroup(metricName: String? = null, name: String? = null):
        GetSubscribedRuleGroupResult {
        val argument = GetSubscribedRuleGroupPlainArgs(
            metricName = metricName,
            name = name,
        )
        return getSubscribedRuleGroupResultToKotlin(getSubscribedRuleGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getSubscribedRuleGroup].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;waf&#46;kotlin&#46;inputs&#46;GetSubscribedRuleGroupPlainArgs].
     * @return A collection of values returned by getSubscribedRuleGroup.
     */
    public suspend
    fun getSubscribedRuleGroup(argument: suspend GetSubscribedRuleGroupPlainArgsBuilder.() -> Unit):
        GetSubscribedRuleGroupResult {
        val builder = GetSubscribedRuleGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSubscribedRuleGroupResultToKotlin(getSubscribedRuleGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * `aws.waf.WebAcl` Retrieves a WAF Web ACL Resource Id.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.waf.WafFunctions;
     * import com.pulumi.aws.waf.inputs.GetWebAclArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = WafFunctions.getWebAcl(GetWebAclArgs.builder()
     *             .name("tfWAFWebACL")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getWebAcl.
     * @return A collection of values returned by getWebAcl.
     */
    public suspend fun getWebAcl(argument: GetWebAclPlainArgs): GetWebAclResult =
        getWebAclResultToKotlin(getWebAclPlain(argument.toJava()).await())

    /**
     * @see [getWebAcl].
     * @param name Name of the WAF Web ACL.
     * @return A collection of values returned by getWebAcl.
     */
    public suspend fun getWebAcl(name: String): GetWebAclResult {
        val argument = GetWebAclPlainArgs(
            name = name,
        )
        return getWebAclResultToKotlin(getWebAclPlain(argument.toJava()).await())
    }

    /**
     * @see [getWebAcl].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;waf&#46;kotlin&#46;inputs&#46;GetWebAclPlainArgs].
     * @return A collection of values returned by getWebAcl.
     */
    public suspend fun getWebAcl(argument: suspend GetWebAclPlainArgsBuilder.() -> Unit):
        GetWebAclResult {
        val builder = GetWebAclPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWebAclResultToKotlin(getWebAclPlain(builtArgument.toJava()).await())
    }
}
