@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.waf.kotlin

import com.pulumi.aws.waf.WebAclArgs.builder
import com.pulumi.aws.waf.kotlin.inputs.WebAclDefaultActionArgs
import com.pulumi.aws.waf.kotlin.inputs.WebAclDefaultActionArgsBuilder
import com.pulumi.aws.waf.kotlin.inputs.WebAclLoggingConfigurationArgs
import com.pulumi.aws.waf.kotlin.inputs.WebAclLoggingConfigurationArgsBuilder
import com.pulumi.aws.waf.kotlin.inputs.WebAclRuleArgs
import com.pulumi.aws.waf.kotlin.inputs.WebAclRuleArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a WAF Web ACL Resource
 * ## Example Usage
 * This example blocks requests coming from `192.0.7.0/24` and allows everything else.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.waf.IpSet;
 * import com.pulumi.aws.waf.IpSetArgs;
 * import com.pulumi.aws.waf.inputs.IpSetIpSetDescriptorArgs;
 * import com.pulumi.aws.waf.Rule;
 * import com.pulumi.aws.waf.RuleArgs;
 * import com.pulumi.aws.waf.inputs.RulePredicateArgs;
 * import com.pulumi.aws.waf.WebAcl;
 * import com.pulumi.aws.waf.WebAclArgs;
 * import com.pulumi.aws.waf.inputs.WebAclDefaultActionArgs;
 * import com.pulumi.aws.waf.inputs.WebAclRuleArgs;
 * import com.pulumi.aws.waf.inputs.WebAclRuleActionArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var ipset = new IpSet("ipset", IpSetArgs.builder()
 *             .ipSetDescriptors(IpSetIpSetDescriptorArgs.builder()
 *                 .type("IPV4")
 *                 .value("192.0.7.0/24")
 *                 .build())
 *             .build());
 *         var wafrule = new Rule("wafrule", RuleArgs.builder()
 *             .metricName("tfWAFRule")
 *             .predicates(RulePredicateArgs.builder()
 *                 .dataId(ipset.id())
 *                 .negated(false)
 *                 .type("IPMatch")
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(ipset)
 *                 .build());
 *         var wafAcl = new WebAcl("wafAcl", WebAclArgs.builder()
 *             .metricName("tfWebACL")
 *             .defaultAction(WebAclDefaultActionArgs.builder()
 *                 .type("ALLOW")
 *                 .build())
 *             .rules(WebAclRuleArgs.builder()
 *                 .action(WebAclRuleActionArgs.builder()
 *                     .type("BLOCK")
 *                     .build())
 *                 .priority(1)
 *                 .ruleId(wafrule.id())
 *                 .type("REGULAR")
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(
 *                     ipset,
 *                     wafrule)
 *                 .build());
 *     }
 * }
 * ```
 * ### Logging
 * > *NOTE:* The Kinesis Firehose Delivery Stream name must begin with `aws-waf-logs-` and be located in `us-east-1` region. See the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/logging.html) for more information about enabling WAF logging.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.waf.WebAcl;
 * import com.pulumi.aws.waf.WebAclArgs;
 * import com.pulumi.aws.waf.inputs.WebAclLoggingConfigurationArgs;
 * import com.pulumi.aws.waf.inputs.WebAclLoggingConfigurationRedactedFieldsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new WebAcl("example", WebAclArgs.builder()
 *             .loggingConfiguration(WebAclLoggingConfigurationArgs.builder()
 *                 .logDestination(aws_kinesis_firehose_delivery_stream.example().arn())
 *                 .redactedFields(WebAclLoggingConfigurationRedactedFieldsArgs.builder()
 *                     .fieldToMatches(
 *                         WebAclLoggingConfigurationRedactedFieldsFieldToMatchArgs.builder()
 *                             .type("URI")
 *                             .build(),
 *                         WebAclLoggingConfigurationRedactedFieldsFieldToMatchArgs.builder()
 *                             .data("referer")
 *                             .type("HEADER")
 *                             .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import WAF Web ACL using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:waf/webAcl:WebAcl main 0c8e583e-18f3-4c13-9e2a-67c4805d2f94
 * ```
 * @property defaultAction Configuration block with action that you want AWS WAF to take when a request doesn't match the criteria in any of the rules that are associated with the web ACL. Detailed below.
 * @property loggingConfiguration Configuration block to enable WAF logging. Detailed below.
 * @property metricName The name or description for the Amazon CloudWatch metric of this web ACL.
 * @property name The name or description of the web ACL.
 * @property rules Configuration blocks containing rules to associate with the web ACL and the settings for each rule. Detailed below.
 * @property tags Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class WebAclArgs(
    public val defaultAction: Output<WebAclDefaultActionArgs>? = null,
    public val loggingConfiguration: Output<WebAclLoggingConfigurationArgs>? = null,
    public val metricName: Output<String>? = null,
    public val name: Output<String>? = null,
    public val rules: Output<List<WebAclRuleArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.waf.WebAclArgs> {
    override fun toJava(): com.pulumi.aws.waf.WebAclArgs = com.pulumi.aws.waf.WebAclArgs.builder()
        .defaultAction(defaultAction?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .loggingConfiguration(
            loggingConfiguration?.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        )
        .metricName(metricName?.applyValue({ args0 -> args0 }))
        .name(name?.applyValue({ args0 -> args0 }))
        .rules(rules?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
        .tags(
            tags?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }),
        ).build()
}

/**
 * Builder for [WebAclArgs].
 */
@PulumiTagMarker
public class WebAclArgsBuilder internal constructor() {
    private var defaultAction: Output<WebAclDefaultActionArgs>? = null

    private var loggingConfiguration: Output<WebAclLoggingConfigurationArgs>? = null

    private var metricName: Output<String>? = null

    private var name: Output<String>? = null

    private var rules: Output<List<WebAclRuleArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Configuration block with action that you want AWS WAF to take when a request doesn't match the criteria in any of the rules that are associated with the web ACL. Detailed below.
     */
    @JvmName("yephmghxvmdpskbe")
    public suspend fun defaultAction(`value`: Output<WebAclDefaultActionArgs>) {
        this.defaultAction = value
    }

    /**
     * @param value Configuration block to enable WAF logging. Detailed below.
     */
    @JvmName("keeagcrpqtcilres")
    public suspend fun loggingConfiguration(`value`: Output<WebAclLoggingConfigurationArgs>) {
        this.loggingConfiguration = value
    }

    /**
     * @param value The name or description for the Amazon CloudWatch metric of this web ACL.
     */
    @JvmName("afyfcmiqcekcirop")
    public suspend fun metricName(`value`: Output<String>) {
        this.metricName = value
    }

    /**
     * @param value The name or description of the web ACL.
     */
    @JvmName("fphgvrrjyljjwwtl")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Configuration blocks containing rules to associate with the web ACL and the settings for each rule. Detailed below.
     */
    @JvmName("nnxojyvplykfplgb")
    public suspend fun rules(`value`: Output<List<WebAclRuleArgs>>) {
        this.rules = value
    }

    @JvmName("owspucoojjcndjgk")
    public suspend fun rules(vararg values: Output<WebAclRuleArgs>) {
        this.rules = Output.all(values.asList())
    }

    /**
     * @param values Configuration blocks containing rules to associate with the web ACL and the settings for each rule. Detailed below.
     */
    @JvmName("xnxtnstrqtuaubfc")
    public suspend fun rules(values: List<Output<WebAclRuleArgs>>) {
        this.rules = Output.all(values)
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("icswtnjrmfajterx")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Configuration block with action that you want AWS WAF to take when a request doesn't match the criteria in any of the rules that are associated with the web ACL. Detailed below.
     */
    @JvmName("ddilevywruylhafh")
    public suspend fun defaultAction(`value`: WebAclDefaultActionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultAction = mapped
    }

    /**
     * @param argument Configuration block with action that you want AWS WAF to take when a request doesn't match the criteria in any of the rules that are associated with the web ACL. Detailed below.
     */
    @JvmName("fnnrhsxirokpjuif")
    public suspend fun defaultAction(argument: suspend WebAclDefaultActionArgsBuilder.() -> Unit) {
        val toBeMapped = WebAclDefaultActionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.defaultAction = mapped
    }

    /**
     * @param value Configuration block to enable WAF logging. Detailed below.
     */
    @JvmName("ubrcmfvqmknbvxgv")
    public suspend fun loggingConfiguration(`value`: WebAclLoggingConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loggingConfiguration = mapped
    }

    /**
     * @param argument Configuration block to enable WAF logging. Detailed below.
     */
    @JvmName("jtrevhyehhsgqdbx")
    public suspend
    fun loggingConfiguration(argument: suspend WebAclLoggingConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = WebAclLoggingConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.loggingConfiguration = mapped
    }

    /**
     * @param value The name or description for the Amazon CloudWatch metric of this web ACL.
     */
    @JvmName("kuyxjbfdxsyhdfpg")
    public suspend fun metricName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metricName = mapped
    }

    /**
     * @param value The name or description of the web ACL.
     */
    @JvmName("nwolnvnsblvretxa")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Configuration blocks containing rules to associate with the web ACL and the settings for each rule. Detailed below.
     */
    @JvmName("jtnkpibvhpydqwuw")
    public suspend fun rules(`value`: List<WebAclRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    /**
     * @param argument Configuration blocks containing rules to associate with the web ACL and the settings for each rule. Detailed below.
     */
    @JvmName("lffykehwqhlbntcc")
    public suspend fun rules(argument: List<suspend WebAclRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { WebAclRuleArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument Configuration blocks containing rules to associate with the web ACL and the settings for each rule. Detailed below.
     */
    @JvmName("meplnvlcgvvsixhn")
    public suspend fun rules(vararg argument: suspend WebAclRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { WebAclRuleArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument Configuration blocks containing rules to associate with the web ACL and the settings for each rule. Detailed below.
     */
    @JvmName("ycwkdworpxqplpyh")
    public suspend fun rules(argument: suspend WebAclRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(WebAclRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param values Configuration blocks containing rules to associate with the web ACL and the settings for each rule. Detailed below.
     */
    @JvmName("qoknmywjmliehtlh")
    public suspend fun rules(vararg values: WebAclRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("knwwmetqvffdumpo")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mhreruhwlfmxvmbo")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): WebAclArgs = WebAclArgs(
        defaultAction = defaultAction,
        loggingConfiguration = loggingConfiguration,
        metricName = metricName,
        name = name,
        rules = rules,
        tags = tags,
    )
}
