@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.waf.kotlin

import com.pulumi.aws.waf.XssMatchSetArgs.builder
import com.pulumi.aws.waf.kotlin.inputs.XssMatchSetXssMatchTupleArgs
import com.pulumi.aws.waf.kotlin.inputs.XssMatchSetXssMatchTupleArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a WAF XSS Match Set Resource
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.waf.XssMatchSet;
 * import com.pulumi.aws.waf.XssMatchSetArgs;
 * import com.pulumi.aws.waf.inputs.XssMatchSetXssMatchTupleArgs;
 * import com.pulumi.aws.waf.inputs.XssMatchSetXssMatchTupleFieldToMatchArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var xssMatchSet = new XssMatchSet("xssMatchSet", XssMatchSetArgs.builder()
 *             .xssMatchTuples(
 *                 XssMatchSetXssMatchTupleArgs.builder()
 *                     .fieldToMatch(XssMatchSetXssMatchTupleFieldToMatchArgs.builder()
 *                         .type("URI")
 *                         .build())
 *                     .textTransformation("NONE")
 *                     .build(),
 *                 XssMatchSetXssMatchTupleArgs.builder()
 *                     .fieldToMatch(XssMatchSetXssMatchTupleFieldToMatchArgs.builder()
 *                         .type("QUERY_STRING")
 *                         .build())
 *                     .textTransformation("NONE")
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import WAF XSS Match Set using their ID. For example:
 * ```sh
 *  $ pulumi import aws:waf/xssMatchSet:XssMatchSet example a1b2c3d4-d5f6-7777-8888-9999aaaabbbbcccc
 * ```
 * @property name The name or description of the SizeConstraintSet.
 * @property xssMatchTuples The parts of web requests that you want to inspect for cross-site scripting attacks.
 */
public data class XssMatchSetArgs(
    public val name: Output<String>? = null,
    public val xssMatchTuples: Output<List<XssMatchSetXssMatchTupleArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.waf.XssMatchSetArgs> {
    override fun toJava(): com.pulumi.aws.waf.XssMatchSetArgs =
        com.pulumi.aws.waf.XssMatchSetArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .xssMatchTuples(
                xssMatchTuples?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [XssMatchSetArgs].
 */
@PulumiTagMarker
public class XssMatchSetArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var xssMatchTuples: Output<List<XssMatchSetXssMatchTupleArgs>>? = null

    /**
     * @param value The name or description of the SizeConstraintSet.
     */
    @JvmName("weejnjygpkvayvjk")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The parts of web requests that you want to inspect for cross-site scripting attacks.
     */
    @JvmName("xtlitnuurptpmmrb")
    public suspend fun xssMatchTuples(`value`: Output<List<XssMatchSetXssMatchTupleArgs>>) {
        this.xssMatchTuples = value
    }

    @JvmName("vqwdoaetaowampbd")
    public suspend fun xssMatchTuples(vararg values: Output<XssMatchSetXssMatchTupleArgs>) {
        this.xssMatchTuples = Output.all(values.asList())
    }

    /**
     * @param values The parts of web requests that you want to inspect for cross-site scripting attacks.
     */
    @JvmName("rbfghutevvigoaym")
    public suspend fun xssMatchTuples(values: List<Output<XssMatchSetXssMatchTupleArgs>>) {
        this.xssMatchTuples = Output.all(values)
    }

    /**
     * @param value The name or description of the SizeConstraintSet.
     */
    @JvmName("leotfuxglwqrmhtx")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The parts of web requests that you want to inspect for cross-site scripting attacks.
     */
    @JvmName("kxtvwxkdqcnfjqxg")
    public suspend fun xssMatchTuples(`value`: List<XssMatchSetXssMatchTupleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.xssMatchTuples = mapped
    }

    /**
     * @param argument The parts of web requests that you want to inspect for cross-site scripting attacks.
     */
    @JvmName("rbtvbjlvjxwaegox")
    public suspend
    fun xssMatchTuples(argument: List<suspend XssMatchSetXssMatchTupleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            XssMatchSetXssMatchTupleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.xssMatchTuples = mapped
    }

    /**
     * @param argument The parts of web requests that you want to inspect for cross-site scripting attacks.
     */
    @JvmName("vqovqedulydtfwix")
    public suspend fun xssMatchTuples(
        vararg
        argument: suspend XssMatchSetXssMatchTupleArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            XssMatchSetXssMatchTupleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.xssMatchTuples = mapped
    }

    /**
     * @param argument The parts of web requests that you want to inspect for cross-site scripting attacks.
     */
    @JvmName("nscnjfujotegkvdu")
    public suspend
    fun xssMatchTuples(argument: suspend XssMatchSetXssMatchTupleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            XssMatchSetXssMatchTupleArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.xssMatchTuples = mapped
    }

    /**
     * @param values The parts of web requests that you want to inspect for cross-site scripting attacks.
     */
    @JvmName("vbwrtipbytrjugco")
    public suspend fun xssMatchTuples(vararg values: XssMatchSetXssMatchTupleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.xssMatchTuples = mapped
    }

    internal fun build(): XssMatchSetArgs = XssMatchSetArgs(
        name = name,
        xssMatchTuples = xssMatchTuples,
    )
}
