@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.waf.kotlin.inputs

import com.pulumi.aws.waf.inputs.ByteMatchSetByteMatchTupleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property fieldToMatch The part of a web request that you want to search, such as a specified header or a query string.
 * @property positionalConstraint Within the portion of a web request that you want to search
 * (for example, in the query string, if any), specify where you want to search.
 * e.g., `CONTAINS`, `CONTAINS_WORD` or `EXACTLY`.
 * See [docs](http://docs.aws.amazon.com/waf/latest/APIReference/API_ByteMatchTuple.html#WAF-Type-ByteMatchTuple-PositionalConstraint)
 * for all supported values.
 * @property targetString The value that you want to search for within the field specified by `field_to_match`, e.g., `badrefer1`.
 * See [docs](https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_ByteMatchTuple.html)
 * for all supported values.
 * @property textTransformation Text transformations used to eliminate unusual formatting that attackers use in web requests in an effort to bypass AWS WAF.
 * If you specify a transformation, AWS WAF performs the transformation on `target_string` before inspecting a request for a match.
 * e.g., `CMD_LINE`, `HTML_ENTITY_DECODE` or `NONE`.
 * See [docs](http://docs.aws.amazon.com/waf/latest/APIReference/API_ByteMatchTuple.html#WAF-Type-ByteMatchTuple-TextTransformation)
 * for all supported values.
 */
public data class ByteMatchSetByteMatchTupleArgs(
    public val fieldToMatch: Output<ByteMatchSetByteMatchTupleFieldToMatchArgs>,
    public val positionalConstraint: Output<String>,
    public val targetString: Output<String>? = null,
    public val textTransformation: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.waf.inputs.ByteMatchSetByteMatchTupleArgs> {
    override fun toJava(): com.pulumi.aws.waf.inputs.ByteMatchSetByteMatchTupleArgs =
        com.pulumi.aws.waf.inputs.ByteMatchSetByteMatchTupleArgs.builder()
            .fieldToMatch(fieldToMatch.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .positionalConstraint(positionalConstraint.applyValue({ args0 -> args0 }))
            .targetString(targetString?.applyValue({ args0 -> args0 }))
            .textTransformation(textTransformation.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ByteMatchSetByteMatchTupleArgs].
 */
@PulumiTagMarker
public class ByteMatchSetByteMatchTupleArgsBuilder internal constructor() {
    private var fieldToMatch: Output<ByteMatchSetByteMatchTupleFieldToMatchArgs>? = null

    private var positionalConstraint: Output<String>? = null

    private var targetString: Output<String>? = null

    private var textTransformation: Output<String>? = null

    /**
     * @param value The part of a web request that you want to search, such as a specified header or a query string.
     */
    @JvmName("wvnpgaujhfymdukw")
    public suspend fun fieldToMatch(`value`: Output<ByteMatchSetByteMatchTupleFieldToMatchArgs>) {
        this.fieldToMatch = value
    }

    /**
     * @param value Within the portion of a web request that you want to search
     * (for example, in the query string, if any), specify where you want to search.
     * e.g., `CONTAINS`, `CONTAINS_WORD` or `EXACTLY`.
     * See [docs](http://docs.aws.amazon.com/waf/latest/APIReference/API_ByteMatchTuple.html#WAF-Type-ByteMatchTuple-PositionalConstraint)
     * for all supported values.
     */
    @JvmName("inllrsbmivanigtk")
    public suspend fun positionalConstraint(`value`: Output<String>) {
        this.positionalConstraint = value
    }

    /**
     * @param value The value that you want to search for within the field specified by `field_to_match`, e.g., `badrefer1`.
     * See [docs](https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_ByteMatchTuple.html)
     * for all supported values.
     */
    @JvmName("ebscjbekmdpminwk")
    public suspend fun targetString(`value`: Output<String>) {
        this.targetString = value
    }

    /**
     * @param value Text transformations used to eliminate unusual formatting that attackers use in web requests in an effort to bypass AWS WAF.
     * If you specify a transformation, AWS WAF performs the transformation on `target_string` before inspecting a request for a match.
     * e.g., `CMD_LINE`, `HTML_ENTITY_DECODE` or `NONE`.
     * See [docs](http://docs.aws.amazon.com/waf/latest/APIReference/API_ByteMatchTuple.html#WAF-Type-ByteMatchTuple-TextTransformation)
     * for all supported values.
     */
    @JvmName("svpcdnwxqnhcwuxp")
    public suspend fun textTransformation(`value`: Output<String>) {
        this.textTransformation = value
    }

    /**
     * @param value The part of a web request that you want to search, such as a specified header or a query string.
     */
    @JvmName("fkxdtqqoikxabyud")
    public suspend fun fieldToMatch(`value`: ByteMatchSetByteMatchTupleFieldToMatchArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fieldToMatch = mapped
    }

    /**
     * @param argument The part of a web request that you want to search, such as a specified header or a query string.
     */
    @JvmName("jkbtwgtklsqltvuy")
    public suspend
    fun fieldToMatch(argument: suspend ByteMatchSetByteMatchTupleFieldToMatchArgsBuilder.() -> Unit) {
        val toBeMapped = ByteMatchSetByteMatchTupleFieldToMatchArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.fieldToMatch = mapped
    }

    /**
     * @param value Within the portion of a web request that you want to search
     * (for example, in the query string, if any), specify where you want to search.
     * e.g., `CONTAINS`, `CONTAINS_WORD` or `EXACTLY`.
     * See [docs](http://docs.aws.amazon.com/waf/latest/APIReference/API_ByteMatchTuple.html#WAF-Type-ByteMatchTuple-PositionalConstraint)
     * for all supported values.
     */
    @JvmName("mviirleeoywlwojs")
    public suspend fun positionalConstraint(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.positionalConstraint = mapped
    }

    /**
     * @param value The value that you want to search for within the field specified by `field_to_match`, e.g., `badrefer1`.
     * See [docs](https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_ByteMatchTuple.html)
     * for all supported values.
     */
    @JvmName("cosernienwboiwyg")
    public suspend fun targetString(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetString = mapped
    }

    /**
     * @param value Text transformations used to eliminate unusual formatting that attackers use in web requests in an effort to bypass AWS WAF.
     * If you specify a transformation, AWS WAF performs the transformation on `target_string` before inspecting a request for a match.
     * e.g., `CMD_LINE`, `HTML_ENTITY_DECODE` or `NONE`.
     * See [docs](http://docs.aws.amazon.com/waf/latest/APIReference/API_ByteMatchTuple.html#WAF-Type-ByteMatchTuple-TextTransformation)
     * for all supported values.
     */
    @JvmName("gppmrsjiejlpagwo")
    public suspend fun textTransformation(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.textTransformation = mapped
    }

    internal fun build(): ByteMatchSetByteMatchTupleArgs = ByteMatchSetByteMatchTupleArgs(
        fieldToMatch = fieldToMatch ?: throw PulumiNullFieldException("fieldToMatch"),
        positionalConstraint = positionalConstraint ?: throw
            PulumiNullFieldException("positionalConstraint"),
        targetString = targetString,
        textTransformation = textTransformation ?: throw PulumiNullFieldException("textTransformation"),
    )
}
