@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.waf.kotlin.inputs

import com.pulumi.aws.waf.inputs.GetRateBasedRulePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getRateBasedRule.
 * @property name Name of the WAF rate based rule.
 */
public data class GetRateBasedRulePlainArgs(
    public val name: String,
) : ConvertibleToJava<com.pulumi.aws.waf.inputs.GetRateBasedRulePlainArgs> {
    override fun toJava(): com.pulumi.aws.waf.inputs.GetRateBasedRulePlainArgs =
        com.pulumi.aws.waf.inputs.GetRateBasedRulePlainArgs.builder()
            .name(name.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRateBasedRulePlainArgs].
 */
@PulumiTagMarker
public class GetRateBasedRulePlainArgsBuilder internal constructor() {
    private var name: String? = null

    /**
     * @param value Name of the WAF rate based rule.
     */
    @JvmName("objxvftruvdbsfhw")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    internal fun build(): GetRateBasedRulePlainArgs = GetRateBasedRulePlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
