@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.waf.kotlin.inputs

import com.pulumi.aws.waf.inputs.IpSetIpSetDescriptorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property type Type of the IP address - `IPV4` or `IPV6`.
 * @property value An IPv4 or IPv6 address specified via CIDR notationE.g., `192.0.2.44/32` or `1111:0000:0000:0000:0000:0000:0000:0000/64`
 */
public data class IpSetIpSetDescriptorArgs(
    public val type: Output<String>,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.waf.inputs.IpSetIpSetDescriptorArgs> {
    override fun toJava(): com.pulumi.aws.waf.inputs.IpSetIpSetDescriptorArgs =
        com.pulumi.aws.waf.inputs.IpSetIpSetDescriptorArgs.builder()
            .type(type.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IpSetIpSetDescriptorArgs].
 */
@PulumiTagMarker
public class IpSetIpSetDescriptorArgsBuilder internal constructor() {
    private var type: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Type of the IP address - `IPV4` or `IPV6`.
     */
    @JvmName("dlotrmmaelqmhivw")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value An IPv4 or IPv6 address specified via CIDR notationE.g., `192.0.2.44/32` or `1111:0000:0000:0000:0000:0000:0000:0000/64`
     */
    @JvmName("slriwknauafdkxpt")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Type of the IP address - `IPV4` or `IPV6`.
     */
    @JvmName("ugvaiomwchdqrkud")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value An IPv4 or IPv6 address specified via CIDR notationE.g., `192.0.2.44/32` or `1111:0000:0000:0000:0000:0000:0000:0000/64`
     */
    @JvmName("cpqovqjgygdwdcio")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): IpSetIpSetDescriptorArgs = IpSetIpSetDescriptorArgs(
        type = type ?: throw PulumiNullFieldException("type"),
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
