@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.waf.kotlin.inputs

import com.pulumi.aws.waf.inputs.RegexMatchSetRegexMatchTupleFieldToMatchArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property data When `type` is `HEADER`, enter the name of the header that you want to search, e.g., `User-Agent` or `Referer`.
 * If `type` is any other value, omit this field.
 * @property type The part of the web request that you want AWS WAF to search for a specified string.
 * e.g., `HEADER`, `METHOD` or `BODY`.
 * See [docs](http://docs.aws.amazon.com/waf/latest/APIReference/API_FieldToMatch.html)
 * for all supported values.
 */
public data class RegexMatchSetRegexMatchTupleFieldToMatchArgs(
    public val `data`: Output<String>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.waf.inputs.RegexMatchSetRegexMatchTupleFieldToMatchArgs> {
    override fun toJava(): com.pulumi.aws.waf.inputs.RegexMatchSetRegexMatchTupleFieldToMatchArgs =
        com.pulumi.aws.waf.inputs.RegexMatchSetRegexMatchTupleFieldToMatchArgs.builder()
            .`data`(`data`?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RegexMatchSetRegexMatchTupleFieldToMatchArgs].
 */
@PulumiTagMarker
public class RegexMatchSetRegexMatchTupleFieldToMatchArgsBuilder internal constructor() {
    private var `data`: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value When `type` is `HEADER`, enter the name of the header that you want to search, e.g., `User-Agent` or `Referer`.
     * If `type` is any other value, omit this field.
     */
    @JvmName("nmtovrguorrcnjas")
    public suspend fun `data`(`value`: Output<String>) {
        this.`data` = value
    }

    /**
     * @param value The part of the web request that you want AWS WAF to search for a specified string.
     * e.g., `HEADER`, `METHOD` or `BODY`.
     * See [docs](http://docs.aws.amazon.com/waf/latest/APIReference/API_FieldToMatch.html)
     * for all supported values.
     */
    @JvmName("huuieqckwumfqcoy")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value When `type` is `HEADER`, enter the name of the header that you want to search, e.g., `User-Agent` or `Referer`.
     * If `type` is any other value, omit this field.
     */
    @JvmName("iwjsrblwihdtgyrc")
    public suspend fun `data`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`data` = mapped
    }

    /**
     * @param value The part of the web request that you want AWS WAF to search for a specified string.
     * e.g., `HEADER`, `METHOD` or `BODY`.
     * See [docs](http://docs.aws.amazon.com/waf/latest/APIReference/API_FieldToMatch.html)
     * for all supported values.
     */
    @JvmName("koduphctaifkfyuw")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): RegexMatchSetRegexMatchTupleFieldToMatchArgs =
        RegexMatchSetRegexMatchTupleFieldToMatchArgs(
            `data` = `data`,
            type = type ?: throw PulumiNullFieldException("type"),
        )
}
