@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.waf.kotlin.inputs

import com.pulumi.aws.waf.inputs.RuleGroupActivatedRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property action Specifies the action that CloudFront or AWS WAF takes when a web request matches the conditions in the rule.
 * @property priority Specifies the order in which the rules are evaluated. Rules with a lower value are evaluated before rules with a higher value.
 * @property ruleId The ID of a rule
 * @property type The rule type, either `REGULAR`, `RATE_BASED`, or `GROUP`. Defaults to `REGULAR`.
 */
public data class RuleGroupActivatedRuleArgs(
    public val action: Output<RuleGroupActivatedRuleActionArgs>,
    public val priority: Output<Int>,
    public val ruleId: Output<String>,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.waf.inputs.RuleGroupActivatedRuleArgs> {
    override fun toJava(): com.pulumi.aws.waf.inputs.RuleGroupActivatedRuleArgs =
        com.pulumi.aws.waf.inputs.RuleGroupActivatedRuleArgs.builder()
            .action(action.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .priority(priority.applyValue({ args0 -> args0 }))
            .ruleId(ruleId.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RuleGroupActivatedRuleArgs].
 */
@PulumiTagMarker
public class RuleGroupActivatedRuleArgsBuilder internal constructor() {
    private var action: Output<RuleGroupActivatedRuleActionArgs>? = null

    private var priority: Output<Int>? = null

    private var ruleId: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Specifies the action that CloudFront or AWS WAF takes when a web request matches the conditions in the rule.
     */
    @JvmName("yebqdjguksgwknmy")
    public suspend fun action(`value`: Output<RuleGroupActivatedRuleActionArgs>) {
        this.action = value
    }

    /**
     * @param value Specifies the order in which the rules are evaluated. Rules with a lower value are evaluated before rules with a higher value.
     */
    @JvmName("xbqmirdeipndndsq")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value The ID of a rule
     */
    @JvmName("xechqolipkmbglxr")
    public suspend fun ruleId(`value`: Output<String>) {
        this.ruleId = value
    }

    /**
     * @param value The rule type, either `REGULAR`, `RATE_BASED`, or `GROUP`. Defaults to `REGULAR`.
     */
    @JvmName("sybcxyuiscyhlequ")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Specifies the action that CloudFront or AWS WAF takes when a web request matches the conditions in the rule.
     */
    @JvmName("woykmumwvmlqmoko")
    public suspend fun action(`value`: RuleGroupActivatedRuleActionArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param argument Specifies the action that CloudFront or AWS WAF takes when a web request matches the conditions in the rule.
     */
    @JvmName("iiohovlhosxmkcka")
    public suspend fun action(argument: suspend RuleGroupActivatedRuleActionArgsBuilder.() -> Unit) {
        val toBeMapped = RuleGroupActivatedRuleActionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.action = mapped
    }

    /**
     * @param value Specifies the order in which the rules are evaluated. Rules with a lower value are evaluated before rules with a higher value.
     */
    @JvmName("yprvttkfjucmshnn")
    public suspend fun priority(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value The ID of a rule
     */
    @JvmName("anikfsachtexjmrx")
    public suspend fun ruleId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleId = mapped
    }

    /**
     * @param value The rule type, either `REGULAR`, `RATE_BASED`, or `GROUP`. Defaults to `REGULAR`.
     */
    @JvmName("vqqcmmgwvtgcfwil")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): RuleGroupActivatedRuleArgs = RuleGroupActivatedRuleArgs(
        action = action ?: throw PulumiNullFieldException("action"),
        priority = priority ?: throw PulumiNullFieldException("priority"),
        ruleId = ruleId ?: throw PulumiNullFieldException("ruleId"),
        type = type,
    )
}
