@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.waf.kotlin.inputs

import com.pulumi.aws.waf.inputs.WebAclRuleOverrideActionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property type Specifies how you want AWS WAF to respond to requests that don't match the criteria in any of the `rules`.
 * e.g., `ALLOW` or `BLOCK`
 */
public data class WebAclRuleOverrideActionArgs(
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.waf.inputs.WebAclRuleOverrideActionArgs> {
    override fun toJava(): com.pulumi.aws.waf.inputs.WebAclRuleOverrideActionArgs =
        com.pulumi.aws.waf.inputs.WebAclRuleOverrideActionArgs.builder()
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebAclRuleOverrideActionArgs].
 */
@PulumiTagMarker
public class WebAclRuleOverrideActionArgsBuilder internal constructor() {
    private var type: Output<String>? = null

    /**
     * @param value Specifies how you want AWS WAF to respond to requests that don't match the criteria in any of the `rules`.
     * e.g., `ALLOW` or `BLOCK`
     */
    @JvmName("ofdbnnruhbasksds")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Specifies how you want AWS WAF to respond to requests that don't match the criteria in any of the `rules`.
     * e.g., `ALLOW` or `BLOCK`
     */
    @JvmName("ypfebxmhfimobmih")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): WebAclRuleOverrideActionArgs = WebAclRuleOverrideActionArgs(
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
