@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.waf.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property data When `type` is `HEADER`, enter the name of the header that you want to search, e.g., `User-Agent` or `Referer`.
 * If `type` is any other value, omit this field.
 * @property type The part of the web request that you want AWS WAF to search for a specified string.
 * e.g., `HEADER`, `METHOD` or `BODY`.
 * See [docs](http://docs.aws.amazon.com/waf/latest/APIReference/API_FieldToMatch.html)
 * for all supported values.
 */
public data class RegexMatchSetRegexMatchTupleFieldToMatch(
    public val `data`: String? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.waf.outputs.RegexMatchSetRegexMatchTupleFieldToMatch):
            RegexMatchSetRegexMatchTupleFieldToMatch = RegexMatchSetRegexMatchTupleFieldToMatch(
            `data` = javaType.`data`().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
