@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.waf.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property dataId A unique identifier for a predicate in the rule, such as Byte Match Set ID or IPSet ID.
 * @property negated Set this to `false` if you want to allow, block, or count requests
 * based on the settings in the specified waf_byte_match_set, waf_ipset, aws_waf_size_constraint_set, aws.waf.SqlInjectionMatchSet or aws_waf_xss_match_set.
 * For example, if an IPSet includes the IP address `192.0.2.44`, AWS WAF will allow or block requests based on that IP address.
 * If set to `true`, AWS WAF will allow, block, or count requests based on all IP addresses except `192.0.2.44`.
 * @property type The type of predicate in a rule. Valid values: `ByteMatch`, `GeoMatch`, `IPMatch`, `RegexMatch`, `SizeConstraint`, `SqlInjectionMatch`, or `XssMatch`.
 */
public data class RulePredicate(
    public val dataId: String,
    public val negated: Boolean,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.waf.outputs.RulePredicate): RulePredicate =
            RulePredicate(
                dataId = javaType.dataId(),
                negated = javaType.negated(),
                type = javaType.type(),
            )
    }
}
