@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.waf.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property logDestination Amazon Resource Name (ARN) of Kinesis Firehose Delivery Stream
 * @property redactedFields Configuration block containing parts of the request that you want redacted from the logs. Detailed below.
 */
public data class WebAclLoggingConfiguration(
    public val logDestination: String,
    public val redactedFields: WebAclLoggingConfigurationRedactedFields? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.waf.outputs.WebAclLoggingConfiguration):
            WebAclLoggingConfiguration = WebAclLoggingConfiguration(
            logDestination = javaType.logDestination(),
            redactedFields = javaType.redactedFields().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.waf.kotlin.outputs.WebAclLoggingConfigurationRedactedFields.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
