@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.waf.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property fieldToMatch Specifies where in a web request to look for cross-site scripting attacks.
 * @property textTransformation Text transformations used to eliminate unusual formatting that attackers use in web requests in an effort to bypass AWS WAF.
 * If you specify a transformation, AWS WAF performs the transformation on `target_string` before inspecting a request for a match.
 * e.g., `CMD_LINE`, `HTML_ENTITY_DECODE` or `NONE`.
 * See [docs](http://docs.aws.amazon.com/waf/latest/APIReference/API_XssMatchTuple.html#WAF-Type-XssMatchTuple-TextTransformation)
 * for all supported values.
 */
public data class XssMatchSetXssMatchTuple(
    public val fieldToMatch: XssMatchSetXssMatchTupleFieldToMatch,
    public val textTransformation: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.waf.outputs.XssMatchSetXssMatchTuple):
            XssMatchSetXssMatchTuple = XssMatchSetXssMatchTuple(
            fieldToMatch = javaType.fieldToMatch().let({ args0 ->
                com.pulumi.aws.waf.kotlin.outputs.XssMatchSetXssMatchTupleFieldToMatch.Companion.toKotlin(args0)
            }),
            textTransformation = javaType.textTransformation(),
        )
    }
}
