@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafregional.kotlin

import com.pulumi.aws.wafregional.ByteMatchSetArgs.builder
import com.pulumi.aws.wafregional.kotlin.inputs.ByteMatchSetByteMatchTupleArgs
import com.pulumi.aws.wafregional.kotlin.inputs.ByteMatchSetByteMatchTupleArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a WAF Regional Byte Match Set Resource for use with Application Load Balancer.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.wafregional.ByteMatchSet;
 * import com.pulumi.aws.wafregional.ByteMatchSetArgs;
 * import com.pulumi.aws.wafregional.inputs.ByteMatchSetByteMatchTupleArgs;
 * import com.pulumi.aws.wafregional.inputs.ByteMatchSetByteMatchTupleFieldToMatchArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var byteSet = new ByteMatchSet("byteSet", ByteMatchSetArgs.builder()
 *             .byteMatchTuples(ByteMatchSetByteMatchTupleArgs.builder()
 *                 .fieldToMatch(ByteMatchSetByteMatchTupleFieldToMatchArgs.builder()
 *                     .data("referer")
 *                     .type("HEADER")
 *                     .build())
 *                 .positionalConstraint("CONTAINS")
 *                 .targetString("badrefer1")
 *                 .textTransformation("NONE")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import WAF Regional Byte Match Set using the id. For example:
 * ```sh
 *  $ pulumi import aws:wafregional/byteMatchSet:ByteMatchSet byte_set a1b2c3d4-d5f6-7777-8888-9999aaaabbbbcccc
 * ```
 * @property byteMatchTuples Settings for the ByteMatchSet, such as the bytes (typically a string that corresponds with ASCII characters) that you want AWS WAF to search for in web requests. ByteMatchTuple documented below.
 * @property name The name or description of the ByteMatchSet.
 */
public data class ByteMatchSetArgs(
    public val byteMatchTuples: Output<List<ByteMatchSetByteMatchTupleArgs>>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.wafregional.ByteMatchSetArgs> {
    override fun toJava(): com.pulumi.aws.wafregional.ByteMatchSetArgs =
        com.pulumi.aws.wafregional.ByteMatchSetArgs.builder()
            .byteMatchTuples(
                byteMatchTuples?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ByteMatchSetArgs].
 */
@PulumiTagMarker
public class ByteMatchSetArgsBuilder internal constructor() {
    private var byteMatchTuples: Output<List<ByteMatchSetByteMatchTupleArgs>>? = null

    private var name: Output<String>? = null

    /**
     * @param value Settings for the ByteMatchSet, such as the bytes (typically a string that corresponds with ASCII characters) that you want AWS WAF to search for in web requests. ByteMatchTuple documented below.
     */
    @JvmName("mqqbtadcnnetxsrg")
    public suspend fun byteMatchTuples(`value`: Output<List<ByteMatchSetByteMatchTupleArgs>>) {
        this.byteMatchTuples = value
    }

    @JvmName("ifpwfdmnxkcupjja")
    public suspend fun byteMatchTuples(vararg values: Output<ByteMatchSetByteMatchTupleArgs>) {
        this.byteMatchTuples = Output.all(values.asList())
    }

    /**
     * @param values Settings for the ByteMatchSet, such as the bytes (typically a string that corresponds with ASCII characters) that you want AWS WAF to search for in web requests. ByteMatchTuple documented below.
     */
    @JvmName("rqojcrtybwtpvlyg")
    public suspend fun byteMatchTuples(values: List<Output<ByteMatchSetByteMatchTupleArgs>>) {
        this.byteMatchTuples = Output.all(values)
    }

    /**
     * @param value The name or description of the ByteMatchSet.
     */
    @JvmName("xfhkvgogprjgclrl")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Settings for the ByteMatchSet, such as the bytes (typically a string that corresponds with ASCII characters) that you want AWS WAF to search for in web requests. ByteMatchTuple documented below.
     */
    @JvmName("trofqweoujrpwove")
    public suspend fun byteMatchTuples(`value`: List<ByteMatchSetByteMatchTupleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.byteMatchTuples = mapped
    }

    /**
     * @param argument Settings for the ByteMatchSet, such as the bytes (typically a string that corresponds with ASCII characters) that you want AWS WAF to search for in web requests. ByteMatchTuple documented below.
     */
    @JvmName("nijyfkbklnxmgesf")
    public suspend
    fun byteMatchTuples(argument: List<suspend ByteMatchSetByteMatchTupleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ByteMatchSetByteMatchTupleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.byteMatchTuples = mapped
    }

    /**
     * @param argument Settings for the ByteMatchSet, such as the bytes (typically a string that corresponds with ASCII characters) that you want AWS WAF to search for in web requests. ByteMatchTuple documented below.
     */
    @JvmName("mvfqmcbacusxmiml")
    public suspend fun byteMatchTuples(
        vararg
        argument: suspend ByteMatchSetByteMatchTupleArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ByteMatchSetByteMatchTupleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.byteMatchTuples = mapped
    }

    /**
     * @param argument Settings for the ByteMatchSet, such as the bytes (typically a string that corresponds with ASCII characters) that you want AWS WAF to search for in web requests. ByteMatchTuple documented below.
     */
    @JvmName("mjmoylhqqdhyehdb")
    public suspend
    fun byteMatchTuples(argument: suspend ByteMatchSetByteMatchTupleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ByteMatchSetByteMatchTupleArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.byteMatchTuples = mapped
    }

    /**
     * @param values Settings for the ByteMatchSet, such as the bytes (typically a string that corresponds with ASCII characters) that you want AWS WAF to search for in web requests. ByteMatchTuple documented below.
     */
    @JvmName("sxsoodkxgmlvigfc")
    public suspend fun byteMatchTuples(vararg values: ByteMatchSetByteMatchTupleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.byteMatchTuples = mapped
    }

    /**
     * @param value The name or description of the ByteMatchSet.
     */
    @JvmName("udorfmnmheamsaxg")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): ByteMatchSetArgs = ByteMatchSetArgs(
        byteMatchTuples = byteMatchTuples,
        name = name,
    )
}
