@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafregional.kotlin

import com.pulumi.aws.wafregional.kotlin.outputs.RateBasedRulePredicate
import com.pulumi.aws.wafregional.kotlin.outputs.RateBasedRulePredicate.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [RateBasedRule].
 */
@PulumiTagMarker
public class RateBasedRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RateBasedRuleArgs = RateBasedRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RateBasedRuleArgsBuilder.() -> Unit) {
        val builder = RateBasedRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): RateBasedRule {
        val builtJavaResource = com.pulumi.aws.wafregional.RateBasedRule(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return RateBasedRule(builtJavaResource)
    }
}

/**
 * Provides a WAF Rate Based Rule Resource
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.wafregional.IpSet;
 * import com.pulumi.aws.wafregional.IpSetArgs;
 * import com.pulumi.aws.wafregional.inputs.IpSetIpSetDescriptorArgs;
 * import com.pulumi.aws.wafregional.RateBasedRule;
 * import com.pulumi.aws.wafregional.RateBasedRuleArgs;
 * import com.pulumi.aws.wafregional.inputs.RateBasedRulePredicateArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var ipset = new IpSet("ipset", IpSetArgs.builder()
 *             .ipSetDescriptors(IpSetIpSetDescriptorArgs.builder()
 *                 .type("IPV4")
 *                 .value("192.0.7.0/24")
 *                 .build())
 *             .build());
 *         var wafrule = new RateBasedRule("wafrule", RateBasedRuleArgs.builder()
 *             .metricName("tfWAFRule")
 *             .rateKey("IP")
 *             .rateLimit(100)
 *             .predicates(RateBasedRulePredicateArgs.builder()
 *                 .dataId(ipset.id())
 *                 .negated(false)
 *                 .type("IPMatch")
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(ipset)
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import WAF Regional Rate Based Rule using the id. For example:
 * ```sh
 *  $ pulumi import aws:wafregional/rateBasedRule:RateBasedRule wafrule a1b2c3d4-d5f6-7777-8888-9999aaaabbbbcccc
 * ```
 *
 */
public class RateBasedRule internal constructor(
    override val javaResource: com.pulumi.aws.wafregional.RateBasedRule,
) : KotlinCustomResource(javaResource, RateBasedRuleMapper) {
    /**
     * The ARN of the WAF Regional Rate Based Rule.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The name or description for the Amazon CloudWatch metric of this rule.
     */
    public val metricName: Output<String>
        get() = javaResource.metricName().applyValue({ args0 -> args0 })

    /**
     * The name or description of the rule.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The objects to include in a rule (documented below).
     */
    public val predicates: Output<List<RateBasedRulePredicate>>?
        get() = javaResource.predicates().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> toKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Valid value is IP.
     */
    public val rateKey: Output<String>
        get() = javaResource.rateKey().applyValue({ args0 -> args0 })

    /**
     * The maximum number of requests, which have an identical value in the field specified by the RateKey, allowed in a five-minute period. Minimum value is 100.
     */
    public val rateLimit: Output<Int>
        get() = javaResource.rateLimit().applyValue({ args0 -> args0 })

    /**
     * Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object RateBasedRuleMapper : ResourceMapper<RateBasedRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.wafregional.RateBasedRule::class == javaResource::class

    override fun map(javaResource: Resource): RateBasedRule = RateBasedRule(
        javaResource as
            com.pulumi.aws.wafregional.RateBasedRule,
    )
}

/**
 * @see [RateBasedRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RateBasedRule].
 */
public suspend fun rateBasedRule(
    name: String,
    block: suspend RateBasedRuleResourceBuilder.() -> Unit,
): RateBasedRule {
    val builder = RateBasedRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RateBasedRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun rateBasedRule(name: String): RateBasedRule {
    val builder = RateBasedRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
