@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafregional.kotlin

import com.pulumi.aws.wafregional.kotlin.outputs.RegexMatchSetRegexMatchTuple
import com.pulumi.aws.wafregional.kotlin.outputs.RegexMatchSetRegexMatchTuple.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [RegexMatchSet].
 */
@PulumiTagMarker
public class RegexMatchSetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RegexMatchSetArgs = RegexMatchSetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RegexMatchSetArgsBuilder.() -> Unit) {
        val builder = RegexMatchSetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): RegexMatchSet {
        val builtJavaResource = com.pulumi.aws.wafregional.RegexMatchSet(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return RegexMatchSet(builtJavaResource)
    }
}

/**
 * Provides a WAF Regional Regex Match Set Resource
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.wafregional.RegexPatternSet;
 * import com.pulumi.aws.wafregional.RegexPatternSetArgs;
 * import com.pulumi.aws.wafregional.RegexMatchSet;
 * import com.pulumi.aws.wafregional.RegexMatchSetArgs;
 * import com.pulumi.aws.wafregional.inputs.RegexMatchSetRegexMatchTupleArgs;
 * import com.pulumi.aws.wafregional.inputs.RegexMatchSetRegexMatchTupleFieldToMatchArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleRegexPatternSet = new RegexPatternSet("exampleRegexPatternSet", RegexPatternSetArgs.builder()
 *             .regexPatternStrings(
 *                 "one",
 *                 "two")
 *             .build());
 *         var exampleRegexMatchSet = new RegexMatchSet("exampleRegexMatchSet", RegexMatchSetArgs.builder()
 *             .regexMatchTuples(RegexMatchSetRegexMatchTupleArgs.builder()
 *                 .fieldToMatch(RegexMatchSetRegexMatchTupleFieldToMatchArgs.builder()
 *                     .data("User-Agent")
 *                     .type("HEADER")
 *                     .build())
 *                 .regexPatternSetId(exampleRegexPatternSet.id())
 *                 .textTransformation("NONE")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import WAF Regional Regex Match Set using the id. For example:
 * ```sh
 *  $ pulumi import aws:wafregional/regexMatchSet:RegexMatchSet example a1b2c3d4-d5f6-7777-8888-9999aaaabbbbcccc
 * ```
 *
 */
public class RegexMatchSet internal constructor(
    override val javaResource: com.pulumi.aws.wafregional.RegexMatchSet,
) : KotlinCustomResource(javaResource, RegexMatchSetMapper) {
    /**
     * The name or description of the Regex Match Set.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The regular expression pattern that you want AWS WAF to search for in web requests, the location in requests that you want AWS WAF to search, and other settings. See below.
     */
    public val regexMatchTuples: Output<List<RegexMatchSetRegexMatchTuple>>?
        get() = javaResource.regexMatchTuples().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })
            }).orElse(null)
        })
}

public object RegexMatchSetMapper : ResourceMapper<RegexMatchSet> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.wafregional.RegexMatchSet::class == javaResource::class

    override fun map(javaResource: Resource): RegexMatchSet = RegexMatchSet(
        javaResource as
            com.pulumi.aws.wafregional.RegexMatchSet,
    )
}

/**
 * @see [RegexMatchSet].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RegexMatchSet].
 */
public suspend fun regexMatchSet(
    name: String,
    block: suspend RegexMatchSetResourceBuilder.() -> Unit,
): RegexMatchSet {
    val builder = RegexMatchSetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RegexMatchSet].
 * @param name The _unique_ name of the resulting resource.
 */
public fun regexMatchSet(name: String): RegexMatchSet {
    val builder = RegexMatchSetResourceBuilder()
    builder.name(name)
    return builder.build()
}
